SET FOREIGN_KEY_CHECKS=0;


-- ----------------------------
-- Sequence structure for "public"."classes_id_classes_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS classes_id_classes_seq;
CREATE SEQUENCE classes_id_classes_seq START WITH 21 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."course_catalog_id_curso_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS course_catalog_id_curso_seq;
CREATE SEQUENCE course_catalog_id_curso_seq START WITH 11 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."course_materials_record_id_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS course_materials_record_id_seq;
CREATE SEQUENCE course_materials_record_id_seq START WITH 3 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."exemplo_id_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS exemplo_id_seq;
CREATE SEQUENCE exemplo_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."id_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS id_seq;
CREATE SEQUENCE id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."instructors_id_instructor_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS instructors_id_instructor_seq;
CREATE SEQUENCE instructors_id_instructor_seq START WITH 19 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."reservation_id_reservation_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS reservation_id_reservation_seq;
CREATE SEQUENCE reservation_id_reservation_seq START WITH 104 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."status_id_status_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS status_id_status_seq;
CREATE SEQUENCE status_id_status_seq START WITH 3 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."students_id_student_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS students_id_student_seq;
CREATE SEQUENCE students_id_student_seq START WITH 105 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."sec_groups_code_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS sec_groups_code_seq;
CREATE SEQUENCE sec_groups_code_seq START WITH 11 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for "public"."venues_id_venues_seq"
-- ----------------------------
DROP SEQUENCE IF EXISTS venues_id_venues_seq;
CREATE SEQUENCE venues_id_venues_seq START WITH 9 INCREMENT BY 1;

-- ----------------------------
-- Table structure for classes
-- ----------------------------

CREATE TABLE classes (
  id_classes int(11) NOT NULL AUTO_INCREMENT,
  class_size int(20) DEFAULT NULL,
  status int(60) DEFAULT NULL,
  instructor varchar(60) DEFAULT NULL,
  start_date_time datetime DEFAULT NULL,
  end_date_time datetime DEFAULT NULL,
  confirmed_reservations int(60) DEFAULT NULL,
  start_date date DEFAULT NULL,
  start_time time DEFAULT NULL,
  end_date date DEFAULT NULL,
  end_time time DEFAULT NULL,
  pending_reservations int(40) DEFAULT NULL,
  class_information varchar(200) DEFAULT NULL,
  date_created datetime DEFAULT NULL,
  date_modified datetime DEFAULT NULL,
  id_instructor int(11) NOT NULL,
  id_curso int(10) NOT NULL,
  id_venues int(10) NOT NULL,
  PRIMARY KEY (id_classes),
  KEY status (status),
  KEY id_instructor (id_instructor),
  KEY id_curso (id_curso),
  KEY id_venues (id_venues),
  CONSTRAINT classes_ibfk_1 FOREIGN KEY (id_instructor) REFERENCES instructors (id_instructor),
  CONSTRAINT classes_ibfk_2 FOREIGN KEY (id_curso) REFERENCES course_catalog (id_curso),
  CONSTRAINT classes_ibfk_3 FOREIGN KEY (id_venues) REFERENCES venues (id_venues)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for course_catalog
-- ----------------------------

CREATE TABLE course_catalog (
  id_curso int(11) NOT NULL AUTO_INCREMENT,
  course_title varchar(60) DEFAULT NULL,
  course_description varchar(300) DEFAULT NULL,
  course_lenght varchar(200) DEFAULT NULL,
  course_track varchar(100) DEFAULT NULL,
  date_created datetime DEFAULT NULL,
  date_modified datetime DEFAULT NULL,
  PRIMARY KEY (id_curso)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of course_catalog
-- ----------------------------
INSERT INTO course_catalog VALUES ('2', 'CSR: Customer Service Representative', 'Training Customer Service Representative (CSR) is intended for support center professionals who have direct contact with the client and are responsible for the level of care given.', '220', 'HR Essentials', null, null);
INSERT INTO course_catalog VALUES ('3', 'SCA: Support Center Analyst', 'The HDI Support Center Analyst (SCA) is an intensive course designed for technical support and customer service that regardless of the level of knowledge are responsible for the so-called solution.', '80', 'Finance', null, null);
INSERT INTO course_catalog VALUES ('4', 'DST: Desktop Support Technician', 'This course proves that professional field support, field support and on site have the ability to support customer service, for service management, as well as master the best practices for providing service and support high quality to customers.', '40', 'Business Skills', null, null);
INSERT INTO course_catalog VALUES ('5', 'SCTL: Team Leader Support Center', 'This course is designed for team managers, leaders, coordinators or supervisors Support Centers that need to have leadership skills, learn best practices for managing people, processes, tools and resources from the Support Center as well as understand the value added service in the business', '16', 'HR Essentials', null, null);
INSERT INTO course_catalog VALUES ('6', 'Support Center Manager', 'The Support Center Manager course covers in detail the best management practices of a tactical and operational support center. ', '4', 'HR Essentials', null, '2012-05-11 15:34:24');
INSERT INTO course_catalog VALUES ('7', 'Customer Phone Skills', 'Or- How not to talk to a customer when a customer talks to you.', '10', 'Customer Service Skills', null, null);
INSERT INTO course_catalog VALUES ('8', 'Endomarketing to Service Desk', 'Aimed at directors, managers, coordinators and supervisors of technology that has relationship with the users or any aspects of the business, the workshop Endomarketing for Service Desk is intended to present the benefits of communication in relation to the results obtained by IT to effectively by', '4', 'HR Essentials', null, null);
INSERT INTO course_catalog VALUES ('9', 'Improve your typing skills', 'Using the most common tecniques to improve your typing skills.\r\nThis course can be attended at your computer.', '8', 'Improve your typing skills', '2012-05-11 10:11:05', null);
INSERT INTO course_catalog VALUES ('10', 'Public Speaking', 'Public Speaking, learn how.', '40', 'Public Speaking', '2012-05-11 15:12:06', '2012-05-11 15:35:00');

-- ----------------------------
-- Table structure for course_materials
-- ----------------------------

CREATE TABLE course_materials (
  record_id int(11) NOT NULL AUTO_INCREMENT,
  title varchar(80) DEFAULT NULL,
  description varchar(80) DEFAULT NULL,
  file_attachment varchar(80) DEFAULT NULL,
  url varchar(80) DEFAULT NULL,
  related_course varchar(80) DEFAULT NULL,
  date_created datetime DEFAULT NULL,
  date_modified datetime DEFAULT NULL,
  PRIMARY KEY (record_id)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of course_materials
-- ----------------------------
INSERT INTO course_materials VALUES ('1', 'Course Presentation', 'This is a sample of an attachment to the course', 'sample.ppt.zip', 'ttt', '2', null, null);
INSERT INTO course_materials VALUES ('2', 'SEC Website for Insider Training', 'This is the definition of Insider Trading', 'ttt', 'http://www.sec.gov/answers/insider.htm', '2', null, null);

-- ----------------------------
-- Table structure for instructors
-- ----------------------------

CREATE TABLE instructors (
  id_instructor int(11) NOT NULL AUTO_INCREMENT,
  instructors varchar(60) DEFAULT NULL,
  email_address varchar(60) DEFAULT NULL,
  phone varchar(40) DEFAULT NULL,
  cell_phone varchar(60) DEFAULT NULL,
  fax varchar(60) DEFAULT NULL,
  address varchar(60) DEFAULT NULL,
  name varchar(40) DEFAULT NULL,
  date_created datetime DEFAULT NULL,
  date_modified datetime DEFAULT NULL,
  PRIMARY KEY (id_instructor)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of instructors
-- ----------------------------
INSERT INTO instructors VALUES ('3', 'clacerda@gmail.com', 'carlos@scriptcase.net', '92555513442', '(925) 555-7301', '', '100 Anytown St. Sunnydale, CA', 'Carlos Lacerda', null, '2012-05-11 15:33:35');
INSERT INTO instructors VALUES ('4', 'chrisbaker@example.com', 'support@scriptcase.net', '(925) 555-1740', '(925) 555-7301', '', '100 Anytown St.Sunnydale, CA', 'Chris Laker', null, '2011-12-02 15:51:59');
INSERT INTO instructors VALUES ('5', 'example_ToniOsheku', 'support@scriptcase.net', '(925) 555-1740', '(925) 555-7301', '', '100 Anytown St.Sunnydale, CA', 'Toni Oshoa', null, '2011-12-02 15:52:14');
INSERT INTO instructors VALUES ('16', 'instructor@scriptcase.com.br', 'instructor@scriptcase.com.br', '', '', '', '', 'Pasquale', '2011-08-30 09:05:52', '2011-12-02 15:51:27');
INSERT INTO instructors VALUES ('17', 'instructor@scriptcase.net', 'instructor@scriptcase.net', '', '', '', '', 'Steve Jobs', '2011-08-30 09:06:26', '2012-05-11 15:13:16');
INSERT INTO instructors VALUES ('18', 'jack@gmail.com', 'jack@gmail.com', '55884741478', '', '', '', 'Jack', '2012-05-11 15:27:18', null);

-- ----------------------------
-- Table structure for reservation
-- ----------------------------

CREATE TABLE reservation (
  id_reservation int(11) NOT NULL AUTO_INCREMENT,
  id_student int(11) DEFAULT NULL,
  status varchar(60) DEFAULT NULL,
  comments varchar(60) DEFAULT NULL,
  id_class int(11) DEFAULT NULL,
  date_created datetime DEFAULT NULL,
  date_modified datetime DEFAULT NULL,
  PRIMARY KEY (id_reservation),
  KEY id_student (id_student),
  KEY id_class (id_class),
  CONSTRAINT reservation_ibfk_1 FOREIGN KEY (id_class) REFERENCES classes (id_classes),
  CONSTRAINT reservation_ibfk_2 FOREIGN KEY (id_student) REFERENCES students (id_student)
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of reservation
-- ----------------------------
INSERT INTO reservation VALUES ('31', '3', 'Finished', null, '3', null, null);
INSERT INTO reservation VALUES ('32', '3', 'Finished', null, '2', null, null);
INSERT INTO reservation VALUES ('38', '3', 'Finished', null, '2', null, null);
INSERT INTO reservation VALUES ('39', '3', 'Finished', null, '4', null, null);
INSERT INTO reservation VALUES ('40', '3', 'Finished', null, '4', null, null);
INSERT INTO reservation VALUES ('41', '3', 'Finished', null, '2', null, null);
INSERT INTO reservation VALUES ('42', '3', 'Finished', null, '2', null, null);
INSERT INTO reservation VALUES ('43', '3', 'Finished', null, '4', null, null);
INSERT INTO reservation VALUES ('44', '3', 'Finished', null, '2', null, null);
INSERT INTO reservation VALUES ('45', '3', 'Finished', null, '3', null, null);
INSERT INTO reservation VALUES ('46', '3', 'Finished', null, '2', null, null);
INSERT INTO reservation VALUES ('47', '3', 'Finished', null, '2', null, null);
INSERT INTO reservation VALUES ('48', '3', 'Finished', null, '4', null, null);
INSERT INTO reservation VALUES ('49', '3', 'Finished', null, '4', null, null);
INSERT INTO reservation VALUES ('50', '3', 'Finished', null, '3', null, null);
INSERT INTO reservation VALUES ('51', '3', 'Finished', null, '4', null, null);
INSERT INTO reservation VALUES ('52', '3', 'Finished', null, '2', null, null);
INSERT INTO reservation VALUES ('82', '2', 'Finished', null, '8', null, null);
INSERT INTO reservation VALUES ('84', '2', 'Finished', null, '13', null, null);
INSERT INTO reservation VALUES ('86', '2', 'Confirmed', null, '5', null, null);
INSERT INTO reservation VALUES ('87', '2', 'Finished', null, '11', null, null);
INSERT INTO reservation VALUES ('94', '3', 'Confirmed', null, '12', null, null);
INSERT INTO reservation VALUES ('96', '103', 'Confirmed', null, '6', null, null);
INSERT INTO reservation VALUES ('97', '103', 'Confirmed', null, '12', null, null);
INSERT INTO reservation VALUES ('98', '103', 'Confirmed', null, '5', null, null);
INSERT INTO reservation VALUES ('100', '17', 'Confirmed', null, '5', null, null);
INSERT INTO reservation VALUES ('102', '103', 'Confirmed', null, '15', null, null);

-- ----------------------------
-- Table structure for status
-- ----------------------------

CREATE TABLE status (
  id_status int(11) NOT NULL AUTO_INCREMENT,
  desc_status varchar(120) DEFAULT NULL,
  PRIMARY KEY (id_status)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of status
-- ----------------------------
INSERT INTO status VALUES ('1', 'Open for Registration');
INSERT INTO status VALUES ('2', 'Finished');

-- ----------------------------
-- Table structure for students
-- ----------------------------

CREATE TABLE students (
  id_student int(11) NOT NULL AUTO_INCREMENT,
  first_name varchar(30) DEFAULT NULL,
  last_name varchar(30) DEFAULT NULL,
  full_name varchar(30) DEFAULT NULL,
  email_address varchar(60) DEFAULT NULL,
  completed_courses varchar(60) DEFAULT NULL,
  company varchar(80) DEFAULT NULL,
  job_title varchar(80) DEFAULT NULL,
  street_address varchar(80) DEFAULT NULL,
  city varchar(80) DEFAULT NULL,
  state varchar(80) DEFAULT NULL,
  zip varchar(80) DEFAULT NULL,
  country varchar(80) DEFAULT NULL,
  fax varchar(40) DEFAULT NULL,
  phone varchar(80) DEFAULT NULL,
  mobile_phone varchar(80) DEFAULT NULL,
  date_created datetime DEFAULT NULL,
  date_modified datetime DEFAULT NULL,
  PRIMARY KEY (id_student)
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of students
-- ----------------------------
INSERT INTO students VALUES ('1', 'Robert', 'Adams', 'Robert Adams', 'radams@scriptcase.net', 'radams@scriptcase.net', 'Corellian Engineering Corp', 'CEO', '156 Sleepy Autumn Acres', 'Binghamton', 'New York', '77486', 'USA', '(992) 555-1752', '(992) 555-1963', '(992) 555-1766', null, '2011-08-23 09:23:54');
INSERT INTO students VALUES ('2', 'Jonathan', 'Alexander', 'Jonathan Alexander', 'jalexander@scriptcase.net', 'jalexander@scriptcase.net', 'Oceanic Airlines', 'IT Manager', '84 Heather Beacon Arbor', 'Boulder', 'Colorado', '88555', 'USA', '(418) 555-9074', '(418) 555-9349', '(418) 555-6114', null, '2011-08-26 11:28:20');
INSERT INTO students VALUES ('3', 'Samuel', 'Allen', 'Samuel Allen', 'sallen@scriptcase.net', 'sallen@scriptcase.net', 'Wayne Enterprises', 'CTO', '74 Little Bluff Bank', 'Koloa', 'Hawaii', '55867', 'USA', '(147) 555-8806', '(147) 555-9205', '(147) 555-7676', null, null);
INSERT INTO students VALUES ('4', 'Andrea', 'Anderson', 'Andrea Anderson', 'aanderson@scriptcase.net', 'aanderson@scriptcase.net', 'Central Services', 'ttt', '198 Indian Brook Bend', 'Brooklyn', 'New York', '26568', 'USA', 'ttt', '(381) 555-4902', '(381) 555-3244', null, null);
INSERT INTO students VALUES ('5', 'Larry', 'Andrews', 'Larry Andrews', 'landrews@scriptcase.net', 'landrews@scriptcase.net', 'Oceanic Airlines', 'IT Manager', '145 Lazy Cloud Canyon', 'Omaha', 'Nebraska', '84741', 'USA', '(744) 555-2928', '(744) 555-7666', '(744) 555-0301', null, null);
INSERT INTO students VALUES ('6', 'Eric', 'Armstrong', 'Eric Armstrong', 'earmstrong@scriptcase.net', 'earmstrong@scriptcase.net', 'Wayne Enterprises', 'CTO', '57 Ridge Creek Corner', 'Atlanta', 'Georgia', '39804', 'USA', '(268) 555-7706', '(268) 555-3300', '(268) 555-5339', null, null);
INSERT INTO students VALUES ('7', 'Thomas', 'Arnold', 'Thomas Arnold', 'tarnold@scriptcase.net', 'tarnold@scriptcase.net', 'Wayne Enterprises', 'IT Manager', '60 Wishing Dale Chase', 'Owego', 'New York', '23177', 'USA', '(993) 555-1179', '(993) 555-7934', '(993) 555-2086', null, null);
INSERT INTO students VALUES ('8', 'Juan', 'Austin', 'Juan Austin', 'jaustin@scriptcase.net', 'jaustin@scriptcase.net', 'Blue Sun Corp', 'ttt', '93 Colonial Deer Court', 'Scottsdale', 'Arizona', '45316', 'USA', 'ttt', '(383) 555-7563', '(383) 555-3719', null, null);
INSERT INTO students VALUES ('9', 'Sandra', 'Bailey', 'Sandra Bailey', 'sbailey@scriptcase.net', 'sbailey@scriptcase.net', 'Blue Sun Corp', 'ttt', '5 Old Falls Cove', 'Cincinatti', 'Ohio', '47303', 'USA', '(422) 555-4946', '(422) 555-9771', '(422) 555-9743', null, null);
INSERT INTO students VALUES ('10', 'Frank', 'Baker', 'Frank Baker', 'fbaker@scriptcase.net', 'fbaker@scriptcase.net', 'Oceanic Airlines', 'IT Manager', '43 Quiet Fox Crest', 'Poipu', 'Hawaii', '36514', 'USA', '(886) 555-3873', '(886) 555-9314', '(886) 555-0390', null, null);
INSERT INTO students VALUES ('11', 'Martha', 'Barnes', 'Martha Barnes', 'mbarnes@scriptcase.net', 'mbarnes@scriptcase.net', 'Blue Sun Corp', 'Director of Marketing', '106 Pleasant Gate Drive', 'Tuscon', 'Arizona', '3968', 'USA', 'ttt', 'ttt', '(991) 555-0976', null, null);
INSERT INTO students VALUES ('12', 'Jerry', 'Bell', 'Jerry Bell', 'jbell@scriptcase.net', 'jbell@scriptcase.net', 'Blue Sun Corp', 'Vice President of Sales', '13 Fawn Hills Edge', 'Toronto', 'Ontario', 'A47 B12', 'Canada', 'ttt', '(367) 555-7729', '(367) 555-6090', null, null);
INSERT INTO students VALUES ('13', 'Cynthia', 'Bennett', 'Cynthia Bennett', 'cbennett@scriptcase.net', 'cbennett@scriptcase.net', 'Mainway Toys', 'Vice President of Sales', '25 Bright Island Estates', 'Phoenix', 'Arizona', '10761', 'USA', '(961) 555-4376', '(961) 555-3772', '(961) 555-5812', null, null);
INSERT INTO students VALUES ('14', 'Mark', 'Berry', 'Mark Berry', 'mberry@scriptcase.net', 'mberry@scriptcase.net', 'Blue Sun Corp', 'ttt', '22 Round Jute Farms', 'Washington, DC', 'District of Columbia', '53020', 'USA', '(983) 555-6278', '(983) 555-0710', '(983) 555-0301', null, null);
INSERT INTO students VALUES ('15', 'Steve', 'Black', 'Steve Black', 'sblack@scriptcase.net', 'sblack@scriptcase.net', 'Blue Sun Corp', 'IT Manager', '66 Silent Lagoon Gardens', 'Brooklyn', 'New York', '13132', 'USA', '(159) 555-2244', '(159) 555-5186', '(159) 555-9582', null, null);
INSERT INTO students VALUES ('16', 'Roger', 'Boyd', 'Roger Boyd', 'rboyd@scriptcase.net', 'rboyd@scriptcase.net', 'Wayne Enterprises', 'Manager', '53 Crystal Lake Glen', 'Little Desert Island', 'Maine', '3017', 'USA', '(869) 555-4944', '(869) 555-8956', '(869) 555-1101', null, null);
INSERT INTO students VALUES ('17', 'Stephen', 'Bradley', 'Stephen Bradley', 'sbradley@scriptcase.net', 'sbradley@scriptcase.net', 'Oceanic Airlines', 'ttt', '26 Cozy Meadow Grove', 'Boulder', 'Colorado', '58562', 'USA', '(484) 555-7582', '(484) 555-9754', '(484) 555-9375', null, null);
INSERT INTO students VALUES ('18', 'Kevin', 'Brooks', 'Kevin Brooks', 'kbrooks@scriptcase.net', 'kbrooks@scriptcase.net', 'Mainway Toys', 'CEO', '87 Noble Mountain Hollow', 'Phoenix', 'Arizona', '67001', 'USA', '(103) 555-0460', '(103) 555-7215', '(103) 555-7917', null, null);
INSERT INTO students VALUES ('19', 'Robin', 'Brown', 'Robin Brown', 'rbrown@scriptcase.net', 'rbrown@scriptcase.net', 'Blue Sun Corp', 'Vice President of Sales', '172 Cotton Nectar Isle', 'New York', 'New York', '79020', 'USA', 'ttt', '(872) 555-6424', '(872) 555-3517', null, null);
INSERT INTO students VALUES ('20', 'Margaret', 'Bryant', 'Margaret Bryant', 'mbryant@scriptcase.net', 'mbryant@scriptcase.net', 'Wayne Enterprises', 'Vice President of Sales', '30 Harvest Oak Jetty', 'Lomax', 'New York', '65039', 'USA', '(622) 555-7880', '(622) 555-1495', '(622) 555-6080', null, null);
INSERT INTO students VALUES ('21', 'Adam', 'Burns', 'Adam Burns', 'aburns@scriptcase.net', 'aburns@scriptcase.net', 'Oceanic Airlines', 'IT Manager', '195 Silver Panda Knoll', 'Fielddale', 'Alabama', '88500', 'USA', '(633) 555-2964', '(633) 555-3763', '(633) 555-2436', null, null);
INSERT INTO students VALUES ('22', 'Louise', 'Butler', 'Louise Butler', 'lbutler@scriptcase.net', 'lbutler@scriptcase.net', 'Oceanic Airlines', 'Team Lead', '176 Cinder Pioneer Landing', 'Pleasantville', 'Kansas', '46199', 'USA', '(617) 555-2393', '(617) 555-9545', '(617) 555-7288', null, null);
INSERT INTO students VALUES ('23', 'Stephanie', 'Campbell', 'Stephanie Campbell', 'scampbell@scriptcase.net', 'scampbell@scriptcase.net', 'Oceanic Airlines', 'ttt', '7 Green Pond Ledge', 'Borride', 'Arizona', '71270', 'USA', 'ttt', '(492) 555-2640', '(492) 555-5372', null, null);
INSERT INTO students VALUES ('24', 'Diana', 'Carpenter', 'Diana Carpenter', 'dcarpenter@scriptcase.net', 'dcarpenter@scriptcase.net', 'Oceanic Airlines', 'ttt', '13 Tawny Prairie Manor', 'Cheyenne', 'Wyoming', '89557', 'USA', '(596) 555-9049', '(596) 555-4329', '(596) 555-8217', null, null);
INSERT INTO students VALUES ('25', 'Kathryn', 'Carroll', 'Kathryn Carroll', 'kcarroll@scriptcase.net', 'kcarroll@scriptcase.net', 'Mainway Toys', 'Team Lead', '195 Dewy Quail Nook', 'Marquette', 'Arizona', '78686', 'USA', '(616) 555-3101', 'ttt', '(616) 555-8159', null, null);
INSERT INTO students VALUES ('26', 'Douglas', 'Carter', 'Douglas Carter', 'dcarter@scriptcase.net', 'dcarter@scriptcase.net', 'Blue Sun Corp', 'Team Lead', '199 Sunny Race Orchard', 'Plato', 'South Dakota', '29878', 'USA', '(117) 555-8643', '(117) 555-8749', '(117) 555-8674', null, null);
INSERT INTO students VALUES ('27', 'Shawn', 'Chavez', 'Shawn Chavez', 'schavez@scriptcase.net', 'schavez@scriptcase.net', 'Oceanic Airlines', 'ttt', '188 Iron Rustic Park', 'Socrates', 'Arizona', '97915', 'USA', 'ttt', '(500) 555-7366', '(500) 555-9746', null, null);
INSERT INTO students VALUES ('28', 'Paula', 'Clark', 'Paula Clark', 'pclark@scriptcase.net', 'Clark, Pat', 'Wayne Enterprises', 'ttt', '79 Emerald Rise Path', 'Aristotle', 'Kentucky', '30459', 'USA', '(268) 555-8142', '(268) 555-4128', '(268) 555-9332', null, null);
INSERT INTO students VALUES ('29', 'Dennis', 'Cole', 'Dennis Cole', 'dcole@scriptcase.net', 'dcole@scriptcase.net', 'Central Services', 'IT Manager', '137 Golden River Place', 'Ukulele', 'Hawaii', '74364', 'USA', '(260) 555-4778', '(260) 555-2674', '(260) 555-3009', null, null);
INSERT INTO students VALUES ('30', 'Anthony', 'Coleman', 'Anthony Coleman', 'acoleman@scriptcase.net', 'acoleman@scriptcase.net', 'Oceanic Airlines', 'ttt', '69 Stony Sky Point', 'Moraga', 'California', '46097', 'USA', '(275) 555-5490', '(275) 555-5860', '(275) 555-5779', null, null);
INSERT INTO students VALUES ('31', 'Frances', 'Collins', 'Frances Collins', 'fcollins@scriptcase.net', 'fcollins@scriptcase.net', 'Wayne Enterprises', 'IT Manager', '92 Misty Spring Run', 'Atlanta', 'Georgia', '29382', 'USA', '(535) 555-2107', '(535) 555-2696', '(535) 555-2941', null, null);
INSERT INTO students VALUES ('32', 'Kelly', 'Cook', 'Kelly Cook', 'kcook@scriptcase.net', 'kcook@scriptcase.net', 'Wayne Enterprises', 'ttt', '26 Rocky Timber Trace', 'Vestal', 'New York', '37057', 'USA', '(891) 555-3822', '(891) 555-7329', '(891) 555-2575', null, null);
INSERT INTO students VALUES ('33', 'Carlos', 'Cooper', 'Carlos Cooper', 'ccooper@scriptcase.net', 'ccooper@scriptcase.net', 'Blue Sun Corp', 'HR Admin', '158 Broad Treasure Valley', 'Lafayette', 'California', '74387', 'USA', '(621) 555-4711', '(621) 555-9416', '(621) 555-8027', null, null);
INSERT INTO students VALUES ('34', 'Gloria', 'Cox', 'Gloria Cox', 'gcox@scriptcase.net', 'gcox@scriptcase.net', 'Blue Sun Corp', 'Team Lead', '64 Shady View Vista', 'ttt', 'ttt', 'E32 11A', 'UK', '(619) 555-9077', '(619) 555-7248', '(619) 555-7894', null, null);
INSERT INTO students VALUES ('35', 'Lois', 'Crawford', 'Lois Crawford', 'lcrawford@scriptcase.net', 'lcrawford@scriptcase.net', 'Oceanic Airlines', 'Team Lead', '2 Hidden Willow Way', 'Annapolis', 'Maryland', '61249', 'USA', '(353) 555-9227', '(353) 555-2169', '(353) 555-4968', null, null);
INSERT INTO students VALUES ('36', 'Michelle', 'Cruz', 'Michelle Cruz', 'mcruz@scriptcase.net', 'mcruz@scriptcase.net', 'Blue Sun Corp', 'CEO', '168 Velvet Zephyr Woods', 'Dickson', 'Colorado', '6236', 'USA', 'ttt', '(595) 555-9800', '(595) 555-4486', null, null);
INSERT INTO students VALUES ('37', 'Cheryl', 'Cunningham', 'Cheryl Cunningham', 'ccunningham@scriptcase.net', 'ccunningham@scriptcase.net', 'Blue Sun Corp', 'Managing Director', '34 Wishing View Landing', 'Vail', 'Colorado', '20019', 'USA', '(993) 555-3093', '(993) 555-5073', '(993) 555-1484', null, null);
INSERT INTO students VALUES ('38', 'Patricia', 'Daniels', 'Patricia Daniels', 'pdaniels@scriptcase.net', 'pdaniels@scriptcase.net', 'Mainway Toys', 'Director of Marketing', '87 Silver Falls Vista', 'Happy Valley', 'Georgia', '54443', 'USA', '(630) 555-8584', '(630) 555-8010', '(630) 555-2962', null, null);
INSERT INTO students VALUES ('39', 'Kathy', 'Davis', 'Kathy Davis', 'kdavis@scriptcase.net', 'kdavis@scriptcase.net', 'Blue Sun Corp', 'IT Manager', '165 Tawny Sky Park', 'Sim City', 'North Carolina', '85333', 'USA', '(321) 555-7403', '(321) 555-6199', '(321) 555-9207', null, null);
INSERT INTO students VALUES ('40', 'Albert', 'Diaz', 'Albert Diaz', 'adiaz@scriptcase.net', 'adiaz@scriptcase.net', 'Blue Sun Corp', 'Team Lead', '51 Hidden Island Drive', 'Anne Arundel', 'Maryland', '69840', 'USA', '(811) 555-5296', '(811) 555-9253', '(811) 555-0621', null, null);
INSERT INTO students VALUES ('41', 'Mildred', 'Dixon', 'Mildred Dixon', 'mdixon@scriptcase.net', 'mdixon@scriptcase.net', 'Wayne Enterprises', 'Manager', '57 Harvest Brook Cove', 'Fish Cove', 'Maryland', '25470', 'USA', '(343) 555-8995', '(343) 555-3530', '(343) 555-4330', null, null);
INSERT INTO students VALUES ('42', 'Peter', 'Duncan', 'Peter Duncan', 'pduncan@scriptcase.net', 'pduncan@scriptcase.net', 'Mainway Toys', 'ttt', '78 Cinder Timber Chase', 'Morganville', 'New York', '99110', 'USA', '(857) 555-2636', '(857) 555-6317', '(857) 555-1451', null, null);
INSERT INTO students VALUES ('43', 'Jessica', 'Dunn', 'Jessica Dunn', 'jdunn@scriptcase.net', 'jdunn@scriptcase.net', 'Mainway Toys', 'CTO', '58 Cotton Rise Acres', 'Sagebrush', 'Arizona', '69358', 'USA', 'ttt', '(281) 555-1659', '(281) 555-5061', null, null);
INSERT INTO students VALUES ('44', 'Joe', 'Edwards', 'Joe Edwards', 'jedwards@scriptcase.net', 'jedwards@scriptcase.net', 'Blue Sun Corp', 'ttt', '140 Fawn Lake Orchard', 'ttt', 'ttt', 'B29 A10', 'Canada', '(357) 555-2764', 'ttt', '(357) 555-1578', null, null);
INSERT INTO students VALUES ('45', 'Alan', 'Elliott', 'Alan Elliott', 'aelliott@scriptcase.net', 'aelliott@scriptcase.net', 'Wayne Enterprises', 'ttt', '100 Dewy Pond Corner', 'Honolulu', 'Hawaii', '83685', 'USA', 'ttt', '(356) 555-7900', '(356) 555-0756', null, null);
INSERT INTO students VALUES ('47', 'Willie', 'Evans', 'Willie Evans', 'wevans@scriptcase.net', 'wevans@scriptcase.net', 'Oceanic Airlines', 'ttt', '17 Lazy River Knoll', 'Annapolis', 'Maryland', '10810', 'USA', '(462) 555-1443', '(462) 555-8858', '(462) 555-8060', null, null);
INSERT INTO students VALUES ('49', 'Gary', 'Fisher', 'Gary Fisher', 'gfisher@scriptcase.net', 'gfisher@scriptcase.net', 'Oceanic Airlines', 'Director of Marketing', '75 Velvet Jute Court', 'Storrs', 'Connecticut', '23745', 'USA', '(295) 555-7217', '(295) 555-9304', '(295) 555-3540', null, null);
INSERT INTO students VALUES ('50', 'Jeremy', 'Flores', 'Jeremy Flores', 'jflores@scriptcase.net', 'jflores@scriptcase.net', 'Mainway Toys', 'ttt', '193 Golden Deer Trace', 'Honolulu', 'Hawaii', '9043', 'USA', '(111) 555-6300', '(111) 555-7266', '(111) 555-3872', null, null);
INSERT INTO students VALUES ('51', 'Janet', 'Ford', 'Janet Ford', 'jford@scriptcase.net', 'jford@scriptcase.net', 'Blue Sun Corp', 'IT Manager', '40 Silent Quail Nook', 'Boot Hill', 'Arizona', '15746', 'USA', 'ttt', '(528) 555-6061', '(528) 555-0859', null, null);
INSERT INTO students VALUES ('52', 'Emily', 'Foster', 'Emily Foster', 'efoster@scriptcase.net', 'efoster@scriptcase.net', 'Oceanic Airlines', 'CEO', '70 Old Mountain Glen', 'New Orleans', 'Louisiana', '35555', 'USA', '(605) 555-2668', '(605) 555-4480', '(605) 555-9617', null, null);
INSERT INTO students VALUES ('54', 'Ruby', 'Franklin', 'Ruby Franklin', 'rfranklin@scriptcase.net', 'rfranklin@scriptcase.net', 'Central Services', 'Manager', '18 Pleasant Fox Hollow', 'Centralia', 'Washington', '22523', 'USA', '(742) 555-7801', '(742) 555-0731', '(742) 555-9613', null, null);
INSERT INTO students VALUES ('55', 'Antonio', 'Freeman', 'Antonio Freeman', 'afreeman@scriptcase.net', 'afreeman@scriptcase.net', 'Oceanic Airlines', 'Team Lead', '106 Emerald Pioneer Valley', 'Marquette', 'Maryland', '14284', 'USA', '(328) 555-1739', '(328) 555-3612', '(328) 555-3165', null, null);
INSERT INTO students VALUES ('56', 'Sean', 'Garcia', 'Sean Garcia', 'sgarcia@scriptcase.net', 'sgarcia@scriptcase.net', 'Wayne Enterprises', 'ttt', '168 Bright Cloud Point', 'ttt', 'ttt', '393B90', 'France', '(644) 555-4852', '(644) 555-5892', '(644) 555-4185', null, null);
INSERT INTO students VALUES ('57', 'Paul', 'Gardner', 'Paul Gardner', 'pgardner@scriptcase.net', 'pgardner@scriptcase.net', 'Wayne Enterprises', 'ttt', '189 Colonial Zephyr Manor', 'Portland', 'Oregon', '31207', 'USA', 'ttt', '(642) 555-4066', '(642) 555-1761', null, null);
INSERT INTO students VALUES ('58', 'Peggy', 'Gibson', 'Peggy Gibson', 'pgibson@scriptcase.net', 'pgibson@scriptcase.net', 'Blue Sun Corp', 'CTO', '182 Iron Oak Canyon', 'Hanapepe', 'Hawaii', '88518', 'USA', '(288) 555-0295', '(288) 555-2491', '(288) 555-0542', null, null);
INSERT INTO students VALUES ('59', 'Christine', 'Gomez', 'Christine Gomez', 'cgomez@scriptcase.net', 'gomez, c', 'Blue Sun Corp', 'ttt', '43 Shady Panda Ledge', 'Crab Apple Cove', 'Maine', '27711', 'USA', '(555) 555-4429', '(555) 555-1744', '(555) 555-1876', null, null);
INSERT INTO students VALUES ('60', 'Phillip', 'Gonzales', 'Phillip Gonzales', 'pgonzales@scriptcase.net', 'pgonzales@scriptcase.net', 'Oceanic Airlines', 'ttt', '94 Sunny Autumn Crest', 'ttt', 'ttt', '123B8', 'France', '(852) 555-1351', '(852) 555-5481', '(852) 555-2275', null, null);
INSERT INTO students VALUES ('61', 'Irene', 'Gonzalez', 'Irene Gonzalez', 'igonzalez@scriptcase.net', 'igonzalez@scriptcase.net', 'Blue Sun Corp', 'ttt', '146 Broad Willow Jetty', 'Phoenix', 'Arizona', '49462', 'USA', '(457) 555-0743', '(457) 555-3347', '(457) 555-3565', null, null);
INSERT INTO students VALUES ('62', 'Beverly', 'Gordon', 'Beverly Gordon', 'bgordon@scriptcase.net', 'bgordon@scriptcase.net', 'Blue Sun Corp', 'IT Manager', '66 Indian Spring Arbor', 'St. Louis', 'Missouri', '34878', 'USA', 'ttt', '(587) 555-3750', '(587) 555-3278', null, null);
INSERT INTO students VALUES ('63', 'Arthur', 'Graham', 'Arthur Graham', 'agraham@scriptcase.net', 'agraham@scriptcase.net', 'Mainway Toys', 'IT Manager', '136 Sleepy Beacon Way', 'Gary', 'Indiana', '66439', 'USA', '(688) 555-4543', '(688) 555-2142', '(688) 555-6829', null, null);
INSERT INTO students VALUES ('66', 'Roy', 'Green', 'Roy Green', 'rgreen@scriptcase.net', 'rgreen@scriptcase.net', 'Wayne Enterprises', 'HR Admin', '87 Crystal Nectar Isle', 'Breckenridge', 'Colorado', '39923', 'USA', '(179) 555-1112', '(179) 555-6949', '(179) 555-8520', null, null);
INSERT INTO students VALUES ('67', 'Maria', 'Greene', 'Maria Greene', 'mgreene@scriptcase.net', 'mgreene@scriptcase.net', 'Mainway Toys', 'ttt', '62 Rocky Hills Bend', 'ttt', 'ttt', '068 E43', 'Canada', '(379) 555-3342', '(379) 555-7502', '(379) 555-9814', null, null);
INSERT INTO students VALUES ('68', 'Angela', 'Griffin', 'Angela Griffin', 'agriffin@scriptcase.net', 'agriffin@scriptcase.net', 'Mainway Toys', 'CEO', '56 Little Creek Farms', 'ttt', 'ttt', 'ttt', 'Brazil', '(284) 555-3826', '(284) 555-1026', '(284) 555-2606', null, null);
INSERT INTO students VALUES ('69', 'Jimmy', 'Hall', 'Jimmy Hall', 'jhall@scriptcase.net', 'jhall@scriptcase.net', 'Blue Sun Corp', 'Team Lead', '166 Quiet Lagoon Place', 'Getier', 'South Carolina', '74237', 'ttt', 'ttt', '(818) 555-8026', '(818) 555-5184', null, null);
INSERT INTO students VALUES ('70', 'William', 'Hamilton', 'William Hamilton', 'whamilton@scriptcase.net', 'whamilton@scriptcase.net', 'Wayne Enterprises', 'CTO', '116 Cozy Meadow Grove', 'Scottsdale', 'Arizona', '55619', 'ttt', '(511) 555-7704', 'ttt', '(511) 555-4804', null, null);
INSERT INTO students VALUES ('71', 'Donna', 'Harper', 'Donna Harper', 'dharper@scriptcase.net', 'dharper@scriptcase.net', 'Oceanic Airlines', 'Vice President of Sales', '55 Misty Bluff Estates', 'Oakland', 'California', '1092', 'USA', '(788) 555-7944', '(788) 555-2894', '(788) 555-7265', null, null);
INSERT INTO students VALUES ('72', 'Theresa', 'Harris', 'Theresa Harris', 'tharris@scriptcase.net', 'tharris@scriptcase.net', 'Oceanic Airlines', 'Director of Marketing', '15 Green Race Bank', 'Grosse Pointe', 'Michigan', 'B39 181', 'UK', '(185) 555-6466', '(185) 555-5975', '(185) 555-5771', null, null);
INSERT INTO students VALUES ('73', 'Brandon', 'Harrison', 'Brandon Harrison', 'bharrison@scriptcase.net', 'bharrison@scriptcase.net', 'Oceanic Airlines', 'CEO', 'ttt', 'Tuscaloosa', 'Alabama', '75973', 'USA', '(630) 555-8785', '(630) 555-9078', '(630) 555-6192', null, null);
INSERT INTO students VALUES ('74', 'Jacqueline', 'Hawkins', 'Jacqueline Hawkins', 'jhawkins@scriptcase.net', 'jhawkins@scriptcase.net', 'Oceanic Airlines', 'IT Manager', 'ttt', 'Boise', 'Idaho', '38505', 'USA', '(855) 555-5362', '(855) 555-6291', '(855) 555-3220', null, null);
INSERT INTO students VALUES ('75', 'Ashley', 'Hayes', 'Ashley Hayes', 'ahayes@scriptcase.net', 'ahayes@scriptcase.net', 'Mainway Toys', 'ttt', 'ttt', 'ttt', 'ttt', 'D871 123', 'Mexico', '(608) 555-7840', '(608) 555-4588', '(608) 555-4646', null, null);
INSERT INTO students VALUES ('76', 'Aaron', 'Henderson', 'Aaron Henderson', 'ahenderson@scriptcase.net', 'ahenderson@scriptcase.net', 'Blue Sun Corp', 'VP of Product Management', 'ttt', 'Paige', 'Arizona', '20492', 'USA', 'ttt', '(986) 555-3186', '(986) 555-3595', null, null);
INSERT INTO students VALUES ('77', 'Rebecca', 'Henry', 'Rebecca Henry', 'rhenry@scriptcase.net', 'rhenry@scriptcase.net', 'Oceanic Airlines', 'CTO', 'ttt', 'Oklahoma City', 'Oklahoma', '85684', 'USA', '(462) 555-9378', '(462) 555-4370', '(462) 555-6044', null, null);
INSERT INTO students VALUES ('78', 'Amy', 'Hernandez', 'Amy Hernandez', 'ahernandez@scriptcase.net', 'ahernandez@scriptcase.net', 'Wayne Enterprises', 'CTO', 'ttt', 'ttt', 'ttt', 'ttt', 'Brazil', '(422) 555-2018', 'ttt', '(422) 555-4080', null, null);
INSERT INTO students VALUES ('79', 'Tina', 'Hicks', 'Tina Hicks', 'thicks@scriptcase.net', 'thicks@scriptcase.net', 'Central Services', 'ttt', 'ttt', 'Pittsburgh', 'Pennsylvania', '76035', 'USA', '(912) 555-4755', 'ttt', '(912) 555-4600', null, null);
INSERT INTO students VALUES ('80', 'Julie', 'Hill', 'Julie Hill', 'jhill@scriptcase.net', 'jhill@scriptcase.net', 'Oceanic Airlines', 'CEO', 'ttt', 'Atlanta', 'Georgia', '24401', 'USA', '(768) 555-6340', 'ttt', '(768) 555-2498', null, null);
INSERT INTO students VALUES ('103', 'student', 'internacional', 'student internacional', 'student@scriptcase.net', '', '', '', '', '', '', '', '', '', '', '', '2011-08-26 17:56:24', '2012-05-11 09:58:51');
INSERT INTO students VALUES ('104', 'student brasil', 'student brasil', 'student brasil student brasil', 'student@scriptcase.com.br', '', '', '', '', '', '', '', '', '', '', '', '2011-08-26 17:58:05', null);

-- ----------------------------
-- Table structure for tb_email
-- ----------------------------

CREATE TABLE tb_email (
  idmail int(11) NOT NULL,
  smtp varchar(60) DEFAULT NULL,
  user_name varchar(60) DEFAULT NULL,
  pswd varchar(60) DEFAULT NULL,
  from_mail varchar(40) DEFAULT NULL,
  fld_use int(11) DEFAULT NULL,
  PRIMARY KEY (idmail)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tb_email
-- ----------------------------
INSERT INTO tb_email VALUES ('1', 'smtp.gmail.com', 'yuri@netmake.com.br', 'c2FvcGF1bG8xMjM=', 'yuri@netmake.com.br', '0');

-- ----------------------------
-- Table structure for venues
-- ----------------------------

CREATE TABLE venues (
  id_venues int(11) NOT NULL AUTO_INCREMENT,
  venue_name varchar(40) DEFAULT NULL,
  venue_type varchar(40) DEFAULT NULL,
  address varchar(100) DEFAULT NULL,
  city varchar(60) DEFAULT NULL,
  state varchar(60) DEFAULT NULL,
  zip_code varchar(60) DEFAULT NULL,
  date_created datetime DEFAULT NULL,
  date_modified datetime DEFAULT NULL,
  PRIMARY KEY (id_venues)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of venues
-- ----------------------------
INSERT INTO venues VALUES ('1', 'Newton Conference Room', 'Internal Classroom', '100 5th Avenue, room 7', 'Waltham', 'Massachusetts', '02451', null, '2012-05-11 10:11:26');
INSERT INTO venues VALUES ('2', 'Cambridge Conference Room', 'Internal Classroom', '100 Fifth Avenue', 'Waltham', 'Massachusetts', '02451', null, null);
INSERT INTO venues VALUES ('3', 'Sales Representative', 'Event Location', 'Obere Str. 57', 'Berlin', 'Utah', '', null, '2011-08-30 09:15:15');
INSERT INTO venues VALUES ('4', 'Phils Vegetarian Burger Barn', 'Banquet', 'Avda. de la Constitucion, 2222', 'Mexico D.F.', 'Tennessee', '', null, '2012-05-11 15:31:48');
INSERT INTO venues VALUES ('5', 'Peter Lacrosse Field', 'Event Location', '120 Hanover Sq.', 'London', 'Georgia', '', null, '2011-08-30 09:19:30');
INSERT INTO venues VALUES ('6', 'Eric Stadium', 'External Classroom', 'Mataderos, 2312', 'Buenos Aires', 'Arkansas', '', null, '2011-08-30 09:18:17');
INSERT INTO venues VALUES ('7', 'Bills Windsurf Shop', 'Event Location', 'Berguvsvegen', 'Falkenberg', 'Colorado', '', null, '2012-05-11 15:31:57');
INSERT INTO venues VALUES ('8', 'Elizabeth Arena', 'Event Location', 'Forsterstr. 57', 'Mannheim', 'Maine', '', null, '2011-08-30 09:20:37');


-- ----------------------------
-- Security Tables
-- ----------------------------

CREATE TABLE `sec_apps` (
    `app_name` VARCHAR(128) NOT NULL,
    `app_type` VARCHAR(255),
    `description` VARCHAR(255),
    PRIMARY KEY (`app_name`)
);

INSERT INTO sec_apps VALUES ('blank',	'blank',	'');
INSERT INTO sec_apps VALUES ('container',	'container',	'');
INSERT INTO sec_apps VALUES ('container_instructor',	'container',	'');
INSERT INTO sec_apps VALUES ('form_add_instructors',	'form',	'Instructor :: Add a new Instructor');
INSERT INTO sec_apps VALUES ('form_add_students',	'form',	'Student :: Add a new Student');
INSERT INTO sec_apps VALUES ('form_conf_email',	'form',	'Email Configuration');
INSERT INTO sec_apps VALUES ('form_confirm_classes_label',	'form',	'');
INSERT INTO sec_apps VALUES ('form_confirm_classes_label_detail',	'form',	'');
INSERT INTO sec_apps VALUES ('form_course_catalog',	'form',	'Course :: Add a new course');
INSERT INTO sec_apps VALUES ('form_edit_instructor',	'form',	'Instructor :: Edit an Instructor');
INSERT INTO sec_apps VALUES ('form_instructor_confirm_classes_label',	'form',	'Instructor :: Confirmation Form');
INSERT INTO sec_apps VALUES ('form_instructors',	'form',	'');
INSERT INTO sec_apps VALUES ('form_register_class',	'form',	'Instructor :: Create a new Class');
INSERT INTO sec_apps VALUES ('form_reservation',	'form',	'');
INSERT INTO sec_apps VALUES ('form_students',	'form',	'');
INSERT INTO sec_apps VALUES ('form_unregister_reservation',	'form',	'Class :: Unregister from a Class');
INSERT INTO sec_apps VALUES ('form_update_students',	'form',	'Student :: Edit a Student');
INSERT INTO sec_apps VALUES ('form_venues',	'form',	'Venues :: Add a new Location');
INSERT INTO sec_apps VALUES ('grid_classes_list',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_course_catalog',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_course_catalog_self',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_instructor_classes',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_instructors',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_instructors_details',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_reservation',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_reservation_list',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_reservation_list_instructor',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_reservation_student_detail',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_student_classes',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_student_classes_detail',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_student_classes_details',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_student_classes_list',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_student_reservation_pending',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_students',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_tb_applications',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_tb_groups',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_tb_users',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_venues',	'cons',	'');
INSERT INTO sec_apps VALUES ('grid_venues_details',	'cons',	'');
INSERT INTO sec_apps VALUES ('login',	'contrusr',	'');
INSERT INTO sec_apps VALUES ('menu',	'menu',	'');
INSERT INTO sec_apps VALUES ('app_change_pswd',	'contr',	'Security Application');
INSERT INTO sec_apps VALUES ('app_form_add_users',	'form',	'Security Application');
INSERT INTO sec_apps VALUES ('app_form_edit_users',	'form',	'Security Application');
INSERT INTO sec_apps VALUES ('app_form_sec_apps',	'form',	'Security Application');
INSERT INTO sec_apps VALUES ('app_form_sec_groups',	'form',	'Security Application');
INSERT INTO sec_apps VALUES ('app_form_sec_groups_apps',	'form',	'Security Application');
INSERT INTO sec_apps VALUES ('app_grid_sec_users_groups',	'form',	'Security Application');
INSERT INTO sec_apps VALUES ('app_grid_sec_apps',	'cons',	'Security Application');
INSERT INTO sec_apps VALUES ('app_grid_sec_groups',	'cons',	'Security Application');
INSERT INTO sec_apps VALUES ('app_grid_sec_users',	'cons',	'Security Application');
INSERT INTO sec_apps VALUES ('app_Login',	'contr',	'Security Application');
INSERT INTO sec_apps VALUES ('app_logged',	'contr',	'Security Application');
INSERT INTO sec_apps VALUES ('app_logged_users',	'cons',	'Security Application');
INSERT INTO sec_apps VALUES ('app_retrieve_pswd',	'contr',	'Security Application');
INSERT INTO sec_apps VALUES ('app_search_sec_groups',	'filter',	'Security Application');
INSERT INTO sec_apps VALUES ('app_sync_apps',	'contr',	'Security Application');
INSERT INTO sec_apps VALUES ('app_settings',	'contr',	'Security Application');

CREATE TABLE `sec_groups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`group_id`),
  UNIQUE KEY `description` (`description`)
);

INSERT INTO sec_groups VALUES (1,	'Administrator');
INSERT INTO sec_groups VALUES (9,	'Student');
INSERT INTO sec_groups VALUES (10, 'Instructor');

CREATE TABLE `sec_groups_apps` (
    `group_id` int(11) NOT NULL,
    `app_name` VARCHAR(128) NOT NULL,
    `priv_access` VARCHAR(1),
    `priv_insert` VARCHAR(1),
    `priv_delete` VARCHAR(1),
    `priv_update` VARCHAR(1),
    `priv_export` VARCHAR(1),
    `priv_print` VARCHAR(1),
    PRIMARY KEY (`group_id`, `app_name`)

);

INSERT INTO sec_groups_apps VALUES (1,	'blank',	'Y',	'N',	'N',	'N',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'container',	'Y',	'N',	'N',	'N',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'container_instructor',	'Y',	'N',	'N',	'N',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'control_synchronize',	'Y',	'N',	'N',	'N',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_add_instructors',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_add_students',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_conf_email',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_confirm_classes_label',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_confirm_classes_label_detail',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_course_catalog',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_edit_instructor',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_instructor_confirm_classes_label',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_instructors',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_register_class',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_reservation',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_students',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_tb_applications',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_tb_groups',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_tb_users',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_unregister_reservation',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_update_students',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'form_venues',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'grid_classes_list',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_course_catalog',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_course_catalog_self',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_instructor_classes',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_instructors',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_instructors_details',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_reservation',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_reservation_list',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_reservation_list_instructor',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_reservation_student_detail',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_student_classes',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_student_classes_detail',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_student_classes_details',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_student_classes_list',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_student_reservation_pending',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_students',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_venues',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'grid_venues_details',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'menu',	'Y',	'N',	'N',	'N',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'app_change_pswd',	'Y',	'N',	'N',	'N',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'app_form_add_users',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'app_form_edit_users',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'app_form_sec_apps',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'app_form_sec_groups',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'app_form_sec_groups_apps',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'app_grid_sec_users_groups',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'app_grid_sec_apps',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'app_grid_sec_groups',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'app_grid_sec_users',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'app_logged',	'Y',	'N',	'N',	'N',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'app_logged_users',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (1,	'app_retrieve_pswd',	'Y',	'N',	'N',	'N',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'app_search_sec_groups',	'Y',	'N',	'N',	'N',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'app_sync_apps',	'Y',	'N',	'N',	'N',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (1,	'app_settings',	'Y',	'N',	'N',	'N',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (9,	'blank',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (10,	'blank',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (9,	'container',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (10,	'container',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (10,	'container_instructor',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (9,	'form_confirm_classes_label',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (10,	'form_course_catalog',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (10,	'form_edit_instructor',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (10,	'form_register_class',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (10,	'form_reservation_label',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (9,	'form_unregister_reservation',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (10,	'form_unregister_reservation',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (9,	'form_update_students',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (10,	'form_venues',	'Y',	'Y',	'Y',	'Y',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (10,	'grid_classes_list',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (9,	'grid_course_catalog',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (10,	'grid_course_catalog',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (10,	'grid_course_catalog_self',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (10,	'grid_instructors_details',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (10,	'grid_instructor_classes',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (9,	'grid_reservation_list',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (10,	'grid_reservation_list',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (10,	'grid_reservation_list_instructor',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (9,	'grid_reservation_student_detail',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (9,	'grid_student_classes',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (9,	'grid_student_classes_details',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (9,	'grid_student_classes_list',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (9,	'grid_student_reservation_pending',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (10,	'grid_venues',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (10,	'grid_venues_details',	'Y',	'N',	'N',	'N',	'Y',	'Y');
INSERT INTO sec_groups_apps VALUES (9,	'menu',	'Y',	'N',	'N',	'N',	'N',	'N');
INSERT INTO sec_groups_apps VALUES (10,	'menu',	'Y',	'N',	'N',	'N',	'N',	'N');

CREATE TABLE `sec_logged` (
    `login` VARCHAR(255)  NOT NULL,
    `date_login` VARCHAR(128),
    `sc_session` VARCHAR(32),
    `ip` VARCHAR(32)
);

CREATE TABLE `sec_settings` (
    `set_name` varchar(255) NOT NULL,
    `set_value` varchar(255) NULL,
    PRIMARY KEY (`set_name`)
);

INSERT INTO `sec_settings` VALUES
	 ('brute_force','Y'),
	 ('brute_force_attempts','10'),
	 ('brute_force_time_block','10'),
	 ('captcha','N'),
	 ('cookie_expiration_time','30'),
	 ('enable_2fa','N'),
	 ('enable_2fa_api',''),
	 ('enable_2fa_api_type',''),
	 ('enable_2fa_expiration_time','300'),
	 ('enable_2fa_mode','individual'),
	 ('group_default',''),
	 ('language','N'),
	 ('login_mode','username'),
	 ('mfa_last_updated','30'),
	 ('new_users','N'),
	 ('password_min','5'),
	 ('password_strength','uppercase_letter;lowercase_letter;numbers;special_chars'),
	 ('pswd_last_updated','60'),
	 ('recover_pswd','send_link'),
	 ('remember_me','Y'),
	 ('req_email_act','N'),
	 ('retrieve_password','Y'),
	 ('send_email_adm','N'),
	 ('session_expire','0'),
	 ('smtp_api','custom'),
	 ('smtp_from_email','dadas'),
	 ('smtp_from_name','dadsa'),
	 ('smtp_pass','asdas'),
	 ('smtp_port','465'),
	 ('smtp_security','ssl'),
	 ('smtp_server','sadadas'),
	 ('smtp_user','dassda'),
	 ('theme','scriptcase__NM__Sc9_SweetBlue');

CREATE TABLE `sec_users` (
    `login` VARCHAR(255) NOT NULL,
    `pswd` VARCHAR(255) NOT NULL,
    `name` VARCHAR(64),
    `email` VARCHAR(255),
    `active` VARCHAR(1),
    `activation_code` VARCHAR(32),
    `priv_admin` VARCHAR(1),
    `mfa` VARCHAR(255),
    `picture` LONGBLOB,
	`role` VARCHAR(128),
    `phone` VARCHAR(64),
    `pswd_last_updated` TIMESTAMP,
    `mfa_last_updated` TIMESTAMP NULL DEFAULT NULL,
	id_user int(11),
    PRIMARY KEY (`login`)
);

INSERT INTO sec_users VALUES ('admin', '21232f297a57a5a743894a0e4a801fc3', 'Administrator', 'admin@netmake.com.br',	'Y', NULL, 'Y',	NULL, NULL, NULL, NULL, NULL, NULL,, 1);
INSERT INTO sec_users VALUES ('admin@scriptcase.com.br',	'21232f297a57a5a743894a0e4a801fc3',	'Administrator', 'admin@scriptcase.net', 'Y',	NULL,	'Y',	NULL,	NULL, NULL, NULL, NULL, NULL, 2);
INSERT INTO sec_users VALUES ('admin@scriptcase.net',	'21232f297a57a5a743894a0e4a801fc3',	'Administrator', 'admin@scriptcase.net',	'Y',	NULL,	'Y',	NULL,	NULL, NULL, NULL, NULL, NULL, 3);
INSERT INTO sec_users VALUES ('carlos@netmake.com.br',	'25d55ad283aa400af464c76d713c07ad',	'Carlos', 'carlos@netmake.com.br',	'Y',	NULL,	'N',	NULL,	NULL, NULL, NULL, NULL, NULL, 4);
INSERT INTO sec_users VALUES ('instructor@scriptcase.com.br',	'175cca0310b93021a7d3cfb3e4877ab6',	'Instructor', 'instructor@scriptcase.com.br',	'Y',	NULL,	'N',	NULL,	NULL, NULL, NULL, NULL, NULL, 5);
INSERT INTO sec_users VALUES ('instructor@scriptcase.net',	'175cca0310b93021a7d3cfb3e4877ab6',	'Instructor', 'instructor@scriptcase.net',	'Y',	NULL,	'N',	NULL,	NULL, NULL, NULL, NULL, NULL, 6);
INSERT INTO sec_users VALUES ('student@scriptcase.com.br',	'cd73502828457d15655bbd7a63fb0bc8',	'Student', 'student@scriptcase.com.br',	'Y',	NULL,	'N',	NULL,	NULL, NULL, NULL, NULL, NULL, 7);
INSERT INTO sec_users VALUES ('student@scriptcase.net',	'cd73502828457d15655bbd7a63fb0bc8',	'Student', 'student@scriptcase.net',	'Y',	NULL,	'N',	NULL,	NULL, NULL, NULL, NULL, NULL, 8);


CREATE TABLE `sec_users_groups` (
  `login` varchar(150) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`login`,`group_id`)
);

INSERT INTO sec_users_groups VALUES ('admin',	1);
INSERT INTO sec_users_groups VALUES ('admin@scriptcase.com.br',	1);
INSERT INTO sec_users_groups VALUES ('admin@scriptcase.net',	1);
INSERT INTO sec_users_groups VALUES ('student@scriptcase.com.br',	9);
INSERT INTO sec_users_groups VALUES ('student@scriptcase.net',	9);
INSERT INTO sec_users_groups VALUES ('carlos@netmake.com.br',	10);
INSERT INTO sec_users_groups VALUES ('instructor@scriptcase.com.br',	10);
INSERT INTO sec_users_groups VALUES ('instructor@scriptcase.net',	10);
