<style>
    .ae-menubar #search-panel > #search-result .result-links > .result-item a {
        flex-direction: column;
        justify-content: center;
        align-items: flex-start;
        gap: 0.25rem;
    }

    .ae-menubar #search-panel > #search-result .result-links > .result-item a .search-item-result-label {
        display: flex;
        flex-direction: row;
        justify-content: center;
        align-items: center;
        gap: 0.5rem;
        word-break: break-word;
        flex-wrap: nowrap;
    }

    .ae-menubar #search-panel > #search-result .result-links > .result-item a .search-item-parents-list {
        font-size: .725rem;
        opacity: .45;
        display: flex;
        flex-direction: row;
        align-items: center;
        justify-content: flex-start;
        gap: 0.25rem;
        padding-left: 0rem;
        flex-wrap: wrap;
    }

    .ae-menubar #search-panel > #search-result .result-links > .result-item a .search-item-parents-list .parent-list-item {
        display: flex;
        flex-direction: row;
        align-items: center;
        justify-content: flex-start;
        gap: 0.25rem;
        background: var(--theme-color-secondary);
        padding: 0 0.5rem;
        border-radius: 4px;
    }

    .ae-menubar #search-panel > #search-result .result-links > .result-item a .search-item-parents-list .parent-list-item i {
        font-size: .55rem;
    }

    .ae-menubar #search-panel > #search-result .result-links > .result-item a .search-item-parents-list .parent-list-separator {

    }
</style>
<div class="panel" id="search-panel" role="dialog" aria-label="caixa de busca para itens do menu" aria-hidden="true" data-keep-open="true">
    <div class="section" id="search">
        <i class="lni lni-search-alt m-4"></i>
        <input type="text" id="main-search" autocomplete="off" />
        <a href="javascript:void(0)" data-close="search-button">
            <span id="esc-button-show" class="text">[esc]</span>
            <i class="fa-regular fa-circle-xmark"></i>
        </a>
    </div>
    <div class="section" id="search-result">
        <ul class="result-links"></ul>
    </div>
</div>
<script>

    function buildParents(parents, data) {
        var ret_el = document.createElement("span");
        var first = true;
        ret_el.classList.add('search-item-parents-list');

        parents.forEach(function(unit) {
            var obj = data.find(function(x) {
                return x.id == unit;
            });
            var section_el = document.createElement("span");
            section_el.classList.add('parent-list-item');
            if (first) {
                first = false;
            } else {
                var separator = document.createElement("span");
                var sep_ico = document.createElement("i");
                sep_ico.classList.add('fa-solid', 'fa-arrow-right');
                separator.classList.add('parent-list-separator');
                separator.append(sep_ico);
                ret_el.append(separator);
            }
            if (obj.icon_check == 'S') {
                var iconClass = obj.icon_fa.split(" ");
                var icon = document.createElement("i");
                icon.classList.add(iconClass[0], iconClass[1]);
                section_el.append(icon);
            }
            section_el.append(obj.label);
            ret_el.append(section_el);
        });
        return ret_el;
    }
    function searchInit() {
        var data = flattenItems(items_data);
        var mainSearch = document.getElementById("main-search");
        var resultContainer = document.querySelector("#search-result .result-links");
        var fuse = new Fuse(data, {
            keys: ['label'],
            threshold: 0.3
        });

        mainSearch.addEventListener("input", ev => {
            var searchTerm = ev.target.value;

            resultContainer.innerHTML = "";

            var searchResults = fuse.search(searchTerm);

            searchResults.forEach(result => {
                var li = document.createElement("li");
                var link = document.createElement("a");
                var linkIcon = document.createElement("i");
                var url = result.item.link;
                var disabled = result.item.disabled == 'Y';
                var hasChildren = Object.values(result.item.itens).length > 0;
                var parents = result.item.parent_list;
                var tabName = result.item.id;
                var tabTitle = result.item.label;
                var tabHint = result.item.hint;
                var tabTarget = getTarget(result.item.link_target);
                var tabIcon = '';
                if (!hasChildren) {
                    var span_item = document.createElement("span");
                    span_item.classList.add('search-item-result-label');
                    if (result.item.icon_check == 'S') {
                        var iconFa = document.createElement("i");
                        var iconFaClass = result.item.icon_fa.split(" ");
                        var tabIcon = document.createElement("i")
                        iconFa.classList.add(iconFaClass[0], iconFaClass[1]);
                        tabIcon.classList.add(iconFaClass[0], iconFaClass[1]);
                        tabIcon = tabIcon.outerHTML;
                        span_item.append(iconFa);
                        // link.insertAdjacentElement("beforeend", buildParents(parents, data));
                    } else {
                        tabIcon = ''
                    }
                    if (tabTarget == '_self' && (url == '#' || url == '')) {
                        link.addEventListener('click', function (e) {
                            window.close();
                        });
                    } else {
                        if (typeof openInTab == 'function') {
                            link.addEventListener('click', function (e) {
                                if (tabTarget == 'nm_frame_app') {
                                    e.preventDefault();
                                    e.stopPropagation();
                                    SCMenubar.closePanel();
                                    openInTab(url, tabName, tabTitle, tabHint, tabIcon, tabTarget);
                                }
                            });
                        } else {
                            link.addEventListener('click', function (e) {
                                if (tabTarget == 'nm_frame_app') {
                                    handleLinks(tabName);
                                    SCMenubar.closePanel();
                                }
                            });
                        }
                    }
                    span_item.append(result.item.label);
                    link.append(span_item);
                    <?php if ($menu_data['check_show_search_path'] == 'S') { ?>
                        link.append(buildParents(parents, data));
                    <?php } ?>
                    li.classList.add("result-item");
                    if (disabled) {
                        $(li).attr("disabled", 'disabled');
                    }
                    if (targets_list[result.item.link_target] !== undefined) {
                        link.setAttribute('target', targets_list[result.item.link_target]);
                    }
                    else
                    {
                        link.setAttribute('target', result.item.link_target);
                    }

                    link.setAttribute("href", result.item.link);
                    li.appendChild(link);
                    resultContainer.appendChild(li);
                }
            })
        });
    }
</script>