<?php
/**
 * Classe modulenotification.
 *
 * Modulo de Seguranca.
 *
 * @package     Classes
 * @subpackage  Page
 * @creation    2009/04/14
 * @copyright   NetMake Solucoes em Informatica
 * @author      Juliano Mesquita dos Santos <juliano@netmake.com.br>
 *
 * $Id: nmPagemodulenotification.class.php,v 1.125 2012-02-15 22:23:23 vinicius Exp $
 */

/* Protecao contra hacks */
if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976)) {
    die('invalid access to system file.' .
        '<br /><span style="font-weight: bold">Fatal error</span>: ');
}

/* Classes ancestrais */
nm_load_class('page', 'Page');

/* Definicao da classe */

class nmPageModuleNotification extends nmPage
{
    /* ----- Construtor e Destrutor ------------------------------------ */


    var $arr_steps = array('carregar', 'tabela', 'associar', 'config');
    var $arr_tables_to_import = array('sc_tbapl', 'sc_tbcmp', 'sc_tbevt');
    var $arr_to_replace = array();
    var $step_now;
    var $step_before;
    var $step_after;
    var $arr_tables;

    var $obj_con;

    /**
     * Construtor da classe.
     *
     * Seta o nome da pagina a ser exibida.
     *
     * @access  public
     */
    function __construct()
    {
        global $nm_config;

        if (!$nm_config['flag_versao']['module_notification']['has']) {
            exit;
        }
        nm_load_class('interface', 'Connection');
        $this->obj_con = nmConnection::singleton($_SESSION['nm_session']['user']['cod_grp']);
        $this->obj_con->GetAllConnections();

        $this->setDocType("HTML");
        $this->CheckLogin();
        $this->SetBody('nmPage');
        $this->SetMargin(0);
        $this->SetPage('ModuleNotification');
        $this->SetPageCode(NM_PAGE_COD_PROJ_NEW);
        $this->CheckAjax();

        $this->SetPageSubtitle('');

        //$this->SetScroll('no');
        //$this->setDocType("XHTML 1.0 Transitional");

    } // nmPageApp

    /* ----- Metodos Protegidos ---------------------------------------- */

    /**
     * Checa a entrada via Ajax.
     *
     * @access  protected
     */
    function CheckAjax()
    {
        if (!isset($_REQUEST['nm_ajax']))
            return;

        $this->LoadLang();
        switch ($_REQUEST['nm_option']) {
            case 'getTables':
                $arr_tables = nm_db_tables($_REQUEST['conn'], __FILE__, __LINE__);
                $charset = $this->getCharset();
                $html = '';
                foreach ($arr_tables as $k => $v) {
                    $v = conv_utf8_all($v, $charset);
                    $selected = "";
                    if (isset($_REQUEST['search']) && $_REQUEST['search'] != '@@@@' && stripos($v, $_REQUEST['search']) !== false) {
                        $selected = "selected='selected'";
                        $_REQUEST['search'] = "@@@@";
                    }
                    $html .= "<option " . $selected . " value='" . $v . "'>" . $v . "</option>";
                }
                echo $html;
                break;
            case 'deleteProfile':
                echo $this->deleteProfile($_POST['p']);
                break;
            case 'renameProfile':
                echo $this->renameProfile($_POST['p'], $_POST['new_name']);
                break;
            case 'getFieldsUsr':
                echo $this->GetFields($_REQUEST['conn'], $_REQUEST['table_usr'], $_REQUEST['search'] ?? '@@@@');
                break;
            case 'getfields':
                echo $this->GetFields($_SESSION['nm_session']['module_notification']['profile']['tabela_conn'], $_POST['nm_table_usu']);
                break;
            case 'getdata':
                echo $this->GetData($_POST['from'], $_POST['field']);
                break;
            case 'verify_tables':
                echo $this->verifyTables($_POST['conn'], $_POST['prefix']);
                break;
            case 'verify_apps':
                echo $this->verifyApps($_POST['prefix']);
                break;
            case 'generate':
                $this->generate_step($_POST['step']);
                break;
            case 'getLibs':
                echo nm_get_extenal_libraries_options();
                break;
            case 'verify_profile_name':
                echo $this->verifyProfileName($_POST['p'], $_POST['n']);
                break;
            case 'add_app_session':
                echo $this->addAppSession($_POST['data']);
                break;
            case 'seclib':
                echo $this->setSecurityLib($_POST['option']);
                break;
            case 'reload_api':
                $cod_prj = $_SESSION['nm_session']['user']['cod_grp'];
                nm_load_class('interface', 'Group');
                $obj_grupo = nmGroup::singleton();
                $obj_grupo->LoadData($cod_prj);

                $grp_apis = $obj_grupo->GetData('api');

                $arr_apis = nm_get_arr_api(true);

                $str_retorno = $_REQUEST['with_empty'] == 1 ? "<option value=''>" . nm_get_text_lang("['btn_disabled']") . "</option>" : '';
                $str_retorno .= $_REQUEST['with_custom'] == 1 ? "<option value='custom'>" . nm_get_text_lang("['custom']") . "</option>" : '';
                $arr_types = explode(';', $_REQUEST['type']);
                $str_retorno_tmp = '';
                if (is_array($arr_apis)) {
                    foreach ($arr_apis as $mod => $arr_api) {
                        $str_retorno_tmp = "<optgroup label='" . nm_get_text_lang("['mod_" . $mod . "']") . "'>";
                        $i = 0;
                        foreach ($arr_api as $k => $api) {
                            if (!in_array($mod . "__NM__" . $k, $grp_apis) || !in_array($api['type'], $arr_types)) continue;


                            $str_retorno_tmp .= "<option value='" . $mod . '__NM__' . $api['name'] . "'>" . $api['name'] . " - " . $api['gateway'] . "</option>";
                            $i++;
                        }
                        if ($i > 0) {
                            $str_retorno .= $str_retorno_tmp . "</optgroup>";
                        }
                    }
                }

                echo $str_retorno;
                break;
        }
        exit;
    } // DisplayContent

    function deleteProfile($profile)
    {
        global $nm_config;
        list($type, $profile) = explode('#@NM@#', $profile);
        $profile = strtr($profile, ['..' => '']);
        $arr_paths = array(
            'scriptcase' => $nm_config['path_scriptcase'] . 'module_notification/',
            'sys' => $nm_config['path_sys'] . 'module_notification/',
            'grp' => $nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . '/module_notification/',
            'usr' => $nm_config['path_usr'] . $_SESSION['nm_session']['user']['login'] . '/module_notification/'
        );
        if (file_exists($arr_paths[$type] . $profile)) {
            unlink($arr_paths[$type] . $profile);
        }
        return 'ok';
    }

    function renameProfile($profile, $new_name)
    {
        global $nm_config;
        list($type, $profile) = explode('#@NM@#', $profile);
        $profile = strtr($profile, ['..' => '']);
        $arr_paths = array(
            'scriptcase' => $nm_config['path_scriptcase'] . 'module_notification/',
            'sys' => $nm_config['path_sys'] . 'module_notification/',
            'grp' => $nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . '/module_notification/',
            'usr' => $nm_config['path_usr'] . $_SESSION['nm_session']['user']['login'] . '/module_notification/'
        );
        $message = "";
        if (empty($new_name) || '' != preg_replace('/[a-z0-9_]+/i', '', $new_name) || preg_match('/^[0-9]/i', $new_name)) {
            $message = nm_get_text_lang("['profile_incorrect']");
        } else if (file_exists($arr_paths[$type] . $profile)) {
            if ($this->templateNameExists($type, $profile, $new_name)) {
                $message = nm_get_text_lang("['profile']['name_exists']");
            } else {
                $data = unserialize(file_get_contents($arr_paths[$type] . $profile));
                $data['perfil_save_name'] = $new_name;
                file_put_contents($arr_paths[$type] . $profile, serialize($data));
                $message = 'ok';
            }
        } else {
            $message = nm_get_text_lang("['general_error']");
        }
        return $message;
    }

    function templateNameExists($type, $profile, $new_name)
    {
        global $nm_config;
        $response = false;
        $arr_paths = array(
            'scriptcase' => $nm_config['path_scriptcase'] . 'module_notification/',
            'sys' => $nm_config['path_sys'] . 'module_notification/',
            'grp' => $nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . '/module_notification/',
            'usr' => $nm_config['path_usr'] . $_SESSION['nm_session']['user']['login'] . '/module_notification/'
        );
        $files = array_diff(scandir($arr_paths[$type]), array('..', '.', $profile));
        if (!empty($files)) {
            foreach ($files as $file) {
                $data_temp = unserialize(file_get_contents($arr_paths[$type] . $file));
                if ($data_temp['perfil_save_name'] == $new_name) {
                    $response = true;
                    break;
                }
            }
        }
        return $response;
    }

    function verifyProfileName($type, $profile)
    {
        global $nm_config;
        $response = 'ok';
        $arr_paths = array(
            'scriptcase' => $nm_config['path_scriptcase'] . 'module_notification/',
            'sys' => $nm_config['path_sys'] . 'module_notification/',
            'grp' => $nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . '/module_notification/',
            'usr' => $nm_config['path_usr'] . $_SESSION['nm_session']['user']['login'] . '/module_notification/'
        );
        if (isset($_SESSION['nm_session']['module_notification']['profile']['profile']) &&
            $_SESSION['nm_session']['module_notification']['profile']['profile'] == 'use' &&
            $_SESSION['nm_session']['module_notification']['profile']['perfil_save_name'] == $profile) {
            $response = 'ok';
        } else if (is_file($arr_paths[$type] . $profile . '.sc')) {
            $response = nm_get_text_lang("['profile']['name_exists']");
        }
        return $response;
    }

    function addAppSession($arr_apl)
    {
        global $nm_template;
        if (isset($_SESSION['nm_session']['module_notification']['profile']['pop_app']['selected_apps'])) {
            unset($_SESSION['nm_session']['module_notification']['profile']['pop_app']['selected_apps']);
        }
        $_SESSION['nm_session']['module_notification']['profile']['pop_app']['selected_apps'] = $arr_apl;
        $nm_template->SetVar('selected_apps', $_SESSION['nm_session']['module_notification']['profile']['pop_app']['selected_apps']);
        echo 'ok';
    }

    function setSecurityLib($str_tipo)
    {
        nm_load_class('interface', 'Group');
        $obj_grp = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
        $obj_grp->LoadData($_SESSION['nm_session']['user']['cod_grp']);
        $arr_libraries = $obj_grp->GetData('libraries');
        $do_update = false;
        if ($str_tipo == 'enable') {
            if (!isset($arr_libraries['scriptcase']) || array_search('security', $arr_libraries['scriptcase']) === false) {
                $arr_libraries['scriptcase'][] = 'security';
                $do_update = true;
            }
        } else if ($str_tipo == 'disable') {
            if (isset($arr_libraries['scriptcase']) && array_search('security', $arr_libraries['scriptcase']) !== false) {
                $key = array_search('security', $arr_libraries['scriptcase']);
                unset($arr_libraries['scriptcase'][$key]);
                $do_update = true;
            }
        }
        if ($do_update) {
            $obj_grp->SetData('libraries', $arr_libraries);
            $obj_grp->AtuData($_SESSION['nm_session']['user']['cod_grp']);
            nm_apaga_geracao_library("", true);
        }
        return $do_update;
    }

    /**
     * Recupera Campos da tabelas.
     *
     * @access  protected
     */
    function GetFields($str_conn, $str_tab, $search = '@@@@')
    {
        if (empty($str_tab)) {
            return '';
        }
        $charset = $this->getCharset();
        $arr_conn = $this->obj_con->GetConnection($str_conn);
        if (empty($arr_conn)) {
            return '';
        }
        $arr_flds = nm_db_fields($str_conn, nm_decode_utf8_charset($str_tab, $charset), __FILE__, __LINE__, false, "", $this->obj_con);


        $html = "<option value=''></option>\n";
        foreach ($arr_flds as $fld) {
            $selected = '';
            $field = str_replace('"', '', conv_utf8_all(strtr(trataCampoTabela($fld, $arr_conn['dbms']), array("'" => "\'")), $charset));
            if ($search != '@@@@' && stripos($fld, $search) !== false) {
                $selected = "selected='selected'";
                $_REQUEST['search'] = "@@@@";
            }
            $html .= "<option " . $selected . " value='" . $field . "'>" . $field . "</option>\n";
        }
        return $html;

    }

    function getCharset()
    {
        if (!isset($_SESSION['nm_session']['module_notification']['prj_charset'][$_SESSION['nm_session']['user']['cod_grp']])) {
            nm_load_class('interface', 'Group');
            $obj_grupo = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
            $arr_lang_charset = get_lang_charset('', '', $obj_grupo->GetData('locale_default'), $obj_grupo->GetData('locales'), $obj_grupo->GetData('locales_charset'));
            $_SESSION['nm_session']['module_notification']['prj_charset'][$_SESSION['nm_session']['user']['cod_grp']] = $arr_lang_charset['charset'];
            return $arr_lang_charset['charset'];
        }
        return $_SESSION['nm_session']['module_notification']['prj_charset'][$_SESSION['nm_session']['user']['cod_grp']];
    }//source2array

    function verifyTables($str_conn, $prefix)
    {
        $arr_tables = nm_db_tables($str_conn, __FILE__, __LINE__, FALSE);

        if (is_array($arr_tables) && !empty($arr_tables)) {
            foreach ($arr_tables as $tbl) {
                if (strpos($tbl, ".") !== false) {
                    $arr_tables[] = substr($tbl, strpos($tbl, ".") + 1);
                }
            }
            $arr_new_tables = $this->returnLevelTables();
            foreach ($arr_new_tables as $table) {
                if (in_array($prefix . $table, $arr_tables) || in_array(strtolower($prefix . $table), $arr_tables) || in_array(strtoupper($prefix . $table), $arr_tables)) {
                    return 'tem';
                }
            }
        }
        return 'no';
    }//verifyTables

    /**
     * Retorna array com as tabelas, dependendo do n&iacute;vel de seguranca.
     *
     *
     * @access  protected
     * @global  array $nm_config Array com configuracao do ScriptCase.
     */
    function returnLevelTables()
    {

        return ['inbox', 'pref', 'tags', 'notifications', 'profiles', 'user_tags'];

    }

    function verifyApps($prefix)
    {
        nm_load_class('interface', 'Application');
        $obj_app = new nmApplication();
        $datas = $obj_app->GetApplications($_SESSION['nm_session']['user']['cod_grp'], $_SESSION['nm_session']['user']['cod_ver'], array('Cod_Apl'));
        $c_prefix = strlen($prefix);
        foreach ($datas as $data) {
            if (substr($data['Cod_Apl'], 0, $c_prefix) == $prefix)
                return 'tem';
        }
        return 'no';
    }

    function generate_step($step)
    {
        switch ($step) {
            case 1:
                if ($_SESSION['nm_session']['module_notification']['profile']['perfil_save_perfil'] == 'S') {
                    $this->SaveProfile();
                }
                break;
            case 2:
                $this->load_variable_replace();

                $this->doReplace();
                break;
            case 3:
                $this->load_variable_replace();
                $this->normalizeFolders();
                nm_apaga_geracao_lang($_SESSION['nm_session']['user']['cod_grp'], true);
                nm_load_class('interface', 'LangGenerator');
                $obj_lang = new nmLangGenerator();
                $obj_lang->geraLang();
                nm_cria_geracao_lang($_SESSION['nm_session']['user']['cod_grp']);
                unset($_SESSION['nm_session']['user']['lang_labels'][$_SESSION['nm_session']['user']['cod_grp']]);
                break;
            case 4:
                $arr_session = $_SESSION['nm_session']['module_notification']['profile'];

                nm_load_class('interface', 'Group');
                $obj_group = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
                $force_utf8 = ($obj_group->GetData('force_db_utf8') == 'S');

                $nm_db_usu = nm_db_connect($this->obj_con->GetConnection($arr_session['tabela_conn']), __FILE__, __LINE__, true, "", $force_utf8);
                $this->inserData($nm_db_usu);

                break;
        }
    }

    function SaveProfile()
    {
        $arr_profile = $_SESSION['nm_session']['module_notification']['profile'];
        global $nm_config;
        $arr = serialize($arr_profile);

        switch ($arr_profile['perfil_data_mod']) {
            case 'scriptcase':
                $str_path = $nm_config['path_scriptcase'] . 'module_notification/';
                break;
            case 'sys':
                $str_path = $nm_config['path_sys'] . 'module_notification/';
                break;
            case 'grp':
                $str_path = $nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . '/module_notification/';
                break;

            default:
            case 'usr':
                $str_path = $nm_config['path_usr'] . $_SESSION['nm_session']['user']['login'] . '/module_notification/';
                break;
        }
        if (!is_dir($str_path)) {
            mkdir($str_path, 0777, true);
        }
        $a = file_put_contents($str_path . $arr_profile['perfil_save_name'] . ".sc", $arr);
        return $a;
    }

    /**
     * Retorna a variavel com as configuracoes para replace.
     *
     *
     * @access  protected
     * @global  array $nm_config Array com configuracao do ScriptCase.
     */
    function load_variable_replace()
    {
        global $nm_config, $obj_lic;
        $arr_session = $_SESSION['nm_session']['module_notification']['profile'];

        nm_load_class('interface', 'Group');
        $obj_grupo = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);

        $this->arr_to_replace = array();
        $this->arr_to_replace['sc_tbapl']['Cod_Prj'] = $_SESSION['nm_session']['user']['cod_grp'];
        $this->arr_to_replace['sc_tbapl']['Versao'] = $_SESSION['nm_session']['user']['cod_ver'];
        $this->arr_to_replace['sc_tbapl']['Login'] = $_SESSION['nm_session']['user']['login'];
        $this->arr_to_replace['sc_tbapl']['Data_Inc'] = date('Ymd');
        $this->arr_to_replace['sc_tbapl']['Hora_Inc'] = date('His');
        $this->arr_to_replace['sc_tbapl']['NomeConexao'] = $arr_session['tabela_conn'];


        $this->arr_to_replace['sc_tbapl']['Data_Uacc'] = date('Ymd');
        $this->arr_to_replace['sc_tbapl']['Hora_Uacc'] = date('His');
        $this->arr_to_replace['sc_tbapl']['Folder'] = 'root/' . $arr_session['config_general']['folder_notification'];
        $this->arr_to_replace['sc_tbapl']['Idioma'] = $obj_grupo->GetData('locale_default');
        $this->arr_to_replace['sc_tbapl']['SchemaAll'] = $arr_session['config_general']['theme'];
        $this->arr_to_replace['sc_tbapl']['SchemaSearch'] = $arr_session['config_general']['theme'];
        $this->arr_to_replace['sc_tbapl']['Attr1'] = array();
        $this->arr_to_replace['sc_tbapl']['Attr1']['lang_locale'] = $obj_grupo->GetData('locale_default');
        $this->arr_to_replace['sc_tbapl']['Attr1']['sc_version'] = $_SESSION['nm_session']['status']['ver_sc'];
        $this->arr_to_replace['sc_tbapl']['Attr4']['Imagem_Path'] = $nm_config['path_scase'] . 'file/img';
        $this->arr_to_replace['sc_tbapl']['Attr3']['log_schema'] = $arr_session['config_general']['log'];
        if ($arr_session['config_general']['log'] == '') {
            $this->arr_to_replace['sc_tbapl']['Attr3']['log_events'] = array();
        } else {
            nm_load_class('interface', 'Log');
            $log = nmLog::singleton($_SESSION['nm_session']['user']['cod_grp'], $_SESSION['nm_session']['user']['cod_ver'], $arr_session['config_general']['log']);
            $log->CheckAttr1();
            $data_log = $log->attr1->GetData();
            $data_log = $data_log['DefaultEvents'];
            $this->arr_to_replace['sc_tbapl']['Attr3']['log_all_fields'] = $log->GetData('rec_mode');
            $this->arr_to_replace['sc_tbapl']['Attr3']['log_events'] = $data_log;
        }

        $arr = $obj_grupo->GetData('locales_charset');
        $this->arr_to_replace['sc_tbapl']['Attr1']['charset_html'] = isset($arr[$this->arr_to_replace['sc_tbapl']['Attr1']['lang_locale']]) ? $arr[$this->arr_to_replace['sc_tbapl']['Attr1']['lang_locale']] : '';


        $this->arr_to_replace['sc_tbevt']['Cod_Prj'] = $_SESSION['nm_session']['user']['cod_grp'];
        $this->arr_to_replace['sc_tbevt']['Versao'] = $_SESSION['nm_session']['user']['cod_ver'];

        $this->arr_to_replace['sc_tbcmp']['Cod_Prj'] = $_SESSION['nm_session']['user']['cod_grp'];
        $this->arr_to_replace['sc_tbcmp']['Versao'] = $_SESSION['nm_session']['user']['cod_ver'];
        $this->arr_to_replace['sc_tbcmp']['Login'] = $_SESSION['nm_session']['user']['login'];

        $this->arr_to_replace['campos'] = array(
            'notiftable_inbox' => $arr_session['inbox'] ?? '',
            'notiftable_pref' => isset($arr_session['pref']) ? $arr_session['pref'] : '',
            'notiftable_tags' => isset($arr_session['tags']) ? $arr_session['tags'] : '',
            'notiftable_notifications' => isset($arr_session['notifications']) ? $arr_session['notifications'] : '',
            'notiftable_profiles' => isset($arr_session['profiles']) ? $arr_session['profiles'] : '',
            'notiftable_user_tags' => isset($arr_session['user_tags']) ? $arr_session['user_tags'] : '',
            'sec_users' => isset($arr_session['sec_users']) ? $arr_session['sec_users'] : '',
            'sec_groups' => isset($arr_session['sec_groups']) ? $arr_session['sec_groups'] : '',
            'sec_users_groups' => isset($arr_session['sec_users_groups']) ? $arr_session['sec_users_groups'] : '',
            'sec_apps' => isset($arr_session['sec_apps']) ? $arr_session['sec_apps'] : '',
        );


        $this->arr_to_replace['tabelas'] = array(
            'sec_users' => $_SESSION['nm_session']['module_notification']['profile']['table_usr'] ?? '',
            'sec_groups' => $_SESSION['nm_session']['module_notification']['profile']['table_grp'] ?? '',
            'sec_users_groups' => $_SESSION['nm_session']['module_notification']['profile']['table_usr_grp'] ?? '',
            'sec_apps' => $arr_session['sec_apps']['table'] ?? '',
            'notiftable_inbox' => $arr_session['inbox']['table'] ?? '',
            'notiftable_pref' => isset($arr_session['pref']['table']) ? $arr_session['pref']['table'] : '',
            'notiftable_tags' => isset($arr_session['tags']['table']) ? $arr_session['tags']['table'] : '',
            'notiftable_notifications' => isset($arr_session['notifications']['table']) ? $arr_session['notifications']['table'] : '',
            'notiftable_profiles' => isset($arr_session['profiles']['table']) ? $arr_session['profiles']['table'] : '',
            'notiftable_user_tags' => isset($arr_session['user_tags']['table']) ? $arr_session['user_tags']['table'] : '',

        );

        $arr_table_fields = array();
        $arr_table_fields_all = array();
        foreach ($this->arr_to_replace['tabelas'] as $k => $v) {
            if (isset($this->arr_to_replace['campos'][$k]) && is_array($this->arr_to_replace['campos'][$k])) {
                foreach ($this->arr_to_replace['campos'][$k] as $kc => $vc) {
                    if ($kc == 'table') {
                        $arr_table_fields[$k] = $v;
                        $arr_table_fields[$k . '.' . $k] = $v;
                    }
                    $arr_table_fields[$k . "." . $kc] = $vc;
                    $arr_table_fields_all[$kc] = $vc;
                }
            }
        }
        $prefix_table = $_SESSION['nm_session']['module_notification']['profile']['tabela_seg_prefix'] ?? '';
        $this->arr_to_replace['others']['fix_fix_replace'][$prefix_table . 'inbox.' . $prefix_table . 'tags as ' . $prefix_table . 'tags'] = $prefix_table . 'inbox.notif_tags as notif_tags';
        $this->arr_to_replace['others']['fix_fix_replace'][$prefix_table . 'inbox.' . $prefix_table . 'tags'] = $prefix_table . 'inbox.notif_tags';

        $this->arr_to_replace['others']['mixTableFields'] = $arr_table_fields;
        $this->arr_to_replace['others']['justAllFields'] = $arr_table_fields_all;


        $this->arr_to_replace['others']['protected_var'] = array();
        $this->arr_to_replace['others']['protected_fields'] = $arr_table_fields;

        $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_notification']['profile']['tabela_conn']);
        if (in_array(nm_db_type($arr_conn['dbms']), array('interbase', 'mssql', 'postgres', 'oracle'))) {
            foreach ($this->arr_to_replace['others']['mixTableFields'] as $k => $v) {
                $this->arr_to_replace['others']['protected_fields'][$k] = addslashes($v);
                $this->arr_to_replace['others']['protected_var']["{" . addslashes($v) . "}"] = "{" . unTrataCampoTabela($v) . "}";
                $this->arr_to_replace['others']['protected_var']["[" . addslashes($v) . "]"] = "[" . unTrataCampoTabela($v) . "]";
            }
        }

    }

    function doReplace()
    {
        global $nm_db, $nm_config;

        $old_error_handler = set_error_handler("nm_faz_nada");
        $arr_sql = $this->load_sql($_SESSION['nm_session']['module_notification']['profile']['tipo_nivel']);

        nm_load_class('interface', 'Application');
        nm_load_class('interface', 'MenuApp');
        nm_load_class('interface', 'Field');
        nm_load_class('interface', 'Event');
        $obj_fld = new nmField();
        $obj_app = new nmApplication();
        $obj_menu2 = new nmMenuApp();
        $obj_evt = new nmEvent();
        $arr_apps = array();

        //Alterar o menu
        if ($_SESSION['nm_session']['module_notification']['profile']['config_general']['menu'] != 'new_menu') {
            $app = explode("#@#", $_SESSION['nm_session']['module_notification']['profile']['config_general']['menu']);
            $obj_app->SetApplication($_SESSION['nm_session']['user']['cod_grp'], $app[0], $_SESSION['nm_session']['user']['cod_ver']);
            $obj_app->SetCodField('Cod_Apl');
            $obj_app->SetData('ComandoSelect', '');
            $obj_app->SetData('NomeConexao', $_SESSION['nm_session']['module_notification']['profile']['tabela_conn']);
            $obj_app->setFieldsAsData();
            $obj_app->RetrieveData();

//verificar menu2
            $arr_apps[] = $_SESSION['nm_session']['module_notification']['profile']['config_general']['menu'];

            if ($app[1] == 'menu2') {
                $obj_menu2->SetApplication($_SESSION['nm_session']['user']['cod_grp'], $app[0], $_SESSION['nm_session']['user']['cod_ver']);
                $obj_menu2->SetCodField('Cod_Apl');
                $obj_menu2->SetData('NomeConexao', $_SESSION['nm_session']['module_notification']['profile']['tabela_conn']);
//                $obj_menu2->RetrieveData();
                $obj_menu2->CheckAttr2();

                $arr_data_menu = $obj_menu2->attr2->getTag('navmenu_itens');

                $menu_CS_navmenu = json_decode($arr_data_menu, true);
                $this->maior_id($menu_CS_navmenu['items'], $item, 2);

                $c = $arr_sql['nmapp_menu']['sc_tbapl'][0]['Attr2'];
                $navmenu_itens = json_decode($c['navmenu_itens'], true);
                $this->correct_id($navmenu_itens['items'], $item, 2);
                $navmenu_itens['items'] = $this->normalizeMenu($navmenu_itens['items'], 2);
                $menu_CS_navmenu['items'] = array_merge_recursive($menu_CS_navmenu['items'], $navmenu_itens['items']);
                $arr_data_menu_noti_data = array(
                    'user_table' => $_SESSION['nm_session']['module_notification']['profile']['sec_users']['table'],
                    'user_login' => $_SESSION['nm_session']['module_notification']['profile']['sec_users']['login'],
                    'user_fullname' => $_SESSION['nm_session']['module_notification']['profile']['sec_users']['name'],
                    'user_image' => $_SESSION['nm_session']['module_notification']['profile']['sec_users']['picture'] ?? 'picture',
                    'notif_table' => $_SESSION['nm_session']['module_notification']['profile']['notifications']['table'],
                    'notif_id' => $_SESSION['nm_session']['module_notification']['profile']['notifications']['notif_id'],
                    'notif_title' => $_SESSION['nm_session']['module_notification']['profile']['notifications']['notif_title'],
                    'notif_message' => $_SESSION['nm_session']['module_notification']['profile']['notifications']['notif_message'],
                    'notif_dtexpire' => $_SESSION['nm_session']['module_notification']['profile']['notifications']['notif_dtexpire'],
                    'notif_login_sender' => $_SESSION['nm_session']['module_notification']['profile']['notifications']['notif_login_sender'],
                    'notif_categ' => $_SESSION['nm_session']['module_notification']['profile']['notifications']['notif_categ'],
                    'notif_type' => $_SESSION['nm_session']['module_notification']['profile']['notifications']['notif_type'],
                    'notif_link' => $_SESSION['nm_session']['module_notification']['profile']['notifications']['notif_link'],
                    'inbox_table' => $_SESSION['nm_session']['module_notification']['profile']['inbox']['table'],
                    'inbox_field_notif_id' => $_SESSION['nm_session']['module_notification']['profile']['inbox']['notif_id'],
                    'inbox_field_ontop' => $_SESSION['nm_session']['module_notification']['profile']['inbox']['notif_ontop'],
                    'inbox_field_userid' => $_SESSION['nm_session']['module_notification']['profile']['inbox']['login'],
                    'inbox_field_isread' => $_SESSION['nm_session']['module_notification']['profile']['inbox']['notif_isread'],
                    'inbox_field_read_date' => $_SESSION['nm_session']['module_notification']['profile']['inbox']['notif_dtread'],
                    'inbox_field_sent_date' => $_SESSION['nm_session']['module_notification']['profile']['inbox']['notif_dtsent'],
                    'inbox_field_tag' => $_SESSION['nm_session']['module_notification']['profile']['inbox']['notif_tags'],
                    'inbox_field_important' => $_SESSION['nm_session']['module_notification']['profile']['inbox']['notif_important'],
                    'notif_connection' => $_SESSION['nm_session']['module_notification']['profile']['tabela_conn'],
                );

                $menu_CS_navmenu['notif_data'] = $arr_data_menu_noti_data;
                $menu_CS_navmenu['notif_open_all_app'] = $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app'] . 'grid_sec_notif_inbox';

                $menu_CS_navmenu['font_string'] = 'Open Sans';
                $menu_CS_navmenu['check_shortcut_label'] = 'S';
                $menu_CS_navmenu['check_start_expanded'] = 'S';
                $menu_CS_navmenu['check_use_loader'] = 'N';
                $menu_CS_navmenu['should_reload'] = 'S';
                $menu_CS_navmenu['notif_login_var'] = "[usr_login]";
                $menu_CS_navmenu['notif_refresh_interval'] = 10000;
                $menu_CS_navmenu['notif_limit'] = 10;
                $find_notification = false;
                foreach ($menu_CS_navmenu['tb_items'] as $k => $v) {
                    if ($v['app'] == 'notification') {
                        $find_notification = true;
                        $menu_CS_navmenu['tb_items'][$k]['icon_check'] = 'S';
                        $menu_CS_navmenu['tb_items'][$k]['display'] = 'S';
                    }
                }
                if(!$find_notification){
                    $menu_CS_navmenu['tb_items'][] = [
                        'text' => 'notification',
                        'app' => 'notification',
                        'icon' => 'fas fa-bell',
                        'icon_check' => 'S',
                        'display' => 'S',
                        'id' => 'item_tb_5',
                        'itree' => array('a'=>array('attributes'=>array()), 'icon'=>'', 'li'=>array('attributes'=>array())),
                    ];
                }
                $obj_menu2->attr2->SetTag('navmenu_itens', json_encode($menu_CS_navmenu));
                $obj_menu2->saveAttrN(array(2 => ""));
            } else {

                $arr_data_menu = $obj_app->GetData('comandoselect');
                if (!empty($arr_data_menu)) {
                    $menu_CS = unserialize($arr_data_menu);
                } else {
                    $menu_CS = unserialize('a:1:{s:10:"menu_itens";a:0:{}}');
                }

                $this->maior_id($menu_CS['menu_itens'], $item);

                $comando = unserialize($arr_sql['nmapp_menu_old']['sc_tbapl'][0]['ComandoSelect']);
                $this->correct_id($comando['menu_itens'], $item);
                $comando['menu_itens'] = $this->normalizeMenu($comando['menu_itens']);
                $comando = (is_array($comando)) ? $comando : array();
                $menu_CS = serialize(array_merge_recursive($menu_CS, $comando));
                $obj_app->SetData('ComandoSelect', $menu_CS);

            }

            $obj_evt->SetApplication($_SESSION['nm_session']['user']['cod_grp'], $app[0], $_SESSION['nm_session']['user']['cod_ver']);
            $arr_event = $obj_evt->RetrieveList('E', 'onExecute');

            $on_execute_code = "";
            if (isset($arr_event['onExecute']['codigo'])) {
                $on_execute_code = $arr_event['onExecute']['codigo'];
            }

            if (!is_array($arr_event)) {
                $arr_event = array();
                $arr_event['onExecute'] = array();
                $arr_event['onExecute']['nome'] = "onExecute";
                $arr_event['onExecute']['tipo'] = 'E';
            }
            $arr_event['onExecute']['codigo'] = $on_execute_code;

            foreach ($arr_event['onExecute'] as $key => $value) {
                $obj_evt->SetData($key, $value);
            }
            $obj_evt->SaveData();


            $obj_app->SetData('NomeConexao', $_SESSION['nm_session']['module_notification']['profile']['tabela_conn']);
            $obj_app->SaveData('save');

            if ($app[1] == 'menu2') {
                $obj_menu2->saveAttrN(2);
            }
            //$arr_sql['nmapp_menu'] =
            unset($arr_sql['nmapp_menu']);
        }


        unset($arr_sql['nmapp_menu_old']);
        $arr_protect = array('EntraDetalheOrd', 'Seq', 'Versao');
        // arr_sql[app][tabela][k] => data
        foreach ($arr_sql as $app => $datas) {
            $app_table = $datas["sc_tbapl"][0]['NomeTabela'];
            $data = $this->normalizeApplication($datas["sc_tbapl"][0]);
            $arr_apps[] = protectAjaxChar($data['Cod_Apl']) . "#@#" . $data['Tipo_Apl'] . "#@#" . protectAjaxChar($data['friendly_name'] ?? '');
            $obj_app->SetData('Cod_Prj', $data['Cod_Prj']);
            $obj_app->SetData('Versao', $data['Versao']);
            $obj_app->SetData('Cod_Apl', $data['Cod_Apl']);

            foreach ($data as $k => $d) {
                if (substr($k, 0, 4) == 'Attr') {
                    $data[$k] = serialize($d);
                }
            }

            /*if(isset($data['format_when_digit']))
                unset($data['format_when_digit']);*/

            foreach ($data as $k => $v) {
                $obj_app->SetData($k, $v);
            }
            beginTrans();
            $obj_app->InsertApp();
            commitTrans();

            if (isset($datas["sc_tbcmp"]) && is_array($datas["sc_tbcmp"])) {
                beginTrans();
                foreach ($datas["sc_tbcmp"] as $data) {
                    $data = $this->normalizeField($data, $app_table);
                    if ($data == false) {
                        continue;
                    }
                    foreach ($data as $k => $d) {
                        if (substr($k, 0, 4) == 'Attr') {
                            $data[$k] = serialize($d);
                        }
                    }
                    if (is_array($data['Def_Complemento']))
                        $data['Def_Complemento'] = serialize($data['Def_Complemento']);
                    if (is_array($data['Def_Complemento_Cons']))
                        $data['Def_Complemento_Cons'] = serialize($data['Def_Complemento_Cons']);
                    if (is_array($data['Def_Complemento_Pesq']))
                        $data['Def_Complemento_Pesq'] = serialize($data['Def_Complemento_Pesq']);
                    foreach ($data as $k => $v) {
                        if (!in_array($k, $arr_protect)) {
                            $data[$k] = $nm_db->qstr($v);
                        } else if (empty($v)) {
                            $data[$k] = "NULL";
                        }
                    }
                    $obj_fld->InsertFld($data);
                }
                commitTrans();
            }


            if (isset($datas["sc_tbevt"]) && is_array($datas["sc_tbevt"])) {
                //nm_printr($datas["sc_tbevt"]); exit;
                beginTrans();
                foreach ($datas["sc_tbevt"] as $data) {
                    $data = $this->normalizeEvent($data);
                    if ($data == false) {
                        continue;
                    }

                    $obj_evt->SetData('Cod_Apl', $data['Cod_Apl']);

                    foreach ($data as $k => $v) {
                        if (!in_array($k, $arr_protect)) {
                            $data[$k] = $nm_db->qstr($v);
                        } else if (empty($v)) {
                            $data[$k] = "NULL";
                        }
                    }
                    $obj_evt->InsertEvent($data);
                }
                commitTrans();
            }
        }
        $_SESSION['nm_session']['arr_apps'] = implode("#?#", $arr_apps);
        set_error_handler($old_error_handler);
    }

    /**
     * Retorna os sqls para o n&iacute;vel de seguran&ccedil;a.
     *
     *
     * @access  protected
     * @global  array $nm_config Array com configuracao do ScriptCase.
     */
    function load_sql($level)
    {

        global $nm_config;
        $str_file = $nm_config['path_lib'] . "module_notification/arr_export.sc";
        return json_decode(file_get_contents($str_file), true);
    }

    function maior_id($arr, &$maior = 0, $menu_version = 1)
    {
        $menu_type = $menu_version == 1 ? 'menu_itens' : 'children';
        foreach ($arr as $itens) {
            $id = str_replace('item_', '', $itens['id']);
            $maior = ($maior > $id) ? $maior : $id;
            if (isset($itens[$menu_type]) && count($itens[$menu_type]) > 0) {
                $this->maior_id($itens[$menu_type], $maior, $menu_version);
            }
        }
    }

    function correct_id(&$arr, $id, $menu_version = 1)
    {
        $menu_type = $menu_version == 1 ? 'menu_itens' : 'children';
        foreach ($arr as $k => $itens) {
            $_id = str_replace('item_', '', $itens['id']);
            $arr[$k]['id'] = 'item_' . ((int)$_id + $id);
            if (isset($itens[$menu_type]) && count($itens[$menu_type]) > 0) {
                $this->correct_id($arr[$k][$menu_type], $id, $menu_version);
            }
        }
    }

    function normalizeMenu($datas, $menu_version = 1)
    {
        $menu_type = $menu_version == 1 ? 'menu_itens' : 'children';
        $link = $menu_version == 1 ? 'link' : 'app';

        global $obj_lic;
        $replace = array('nmapp_' => $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app']);
        $arr_datas = $datas;
        $arr_new = array();
        foreach ($datas as $k => $data) {
            $arr_datas[$k][$link] = strtr($data[$link], $replace);
            if (isset($data[$menu_type]) && count($data[$menu_type]) > 0) {
                $arr_datas[$k][$menu_type] = $this->normalizeMenu($data[$menu_type], $menu_version);
            }
            $arr_new[] = $arr_datas[$k];
        }
        return $arr_new;
    } // PageJs

    function normalizeApplication($data)
    {
        global $nm_ini_sys, $nm_config, $obj_lic;
        $data = $this->replace('sc_tbapl', $data);

        if (!empty($data['Campos_Chave'])
            && isset($this->arr_to_replace['campos'][$data['NomeTabela']])
            && isset($this->arr_to_replace['campos'][$data['NomeTabela']][$data['Campos_Chave']])
        ) {
            $data['Campos_Chave'] = $this->arr_to_replace['campos'][$data['NomeTabela']][$data['Campos_Chave']];
        }

        if (isset($data['Attr4']['form_params']) && !empty($data['Attr4']['form_params'])) {
            $form_params = explode(';', $data['Attr4']['form_params']);
            foreach ($form_params as $k => $param) {
                $form_params[$k] = isset($this->arr_to_replace['campos'][$data['NomeTabela']][$param]) ? $this->arr_to_replace['campos'][$data['NomeTabela']][$param] : $param;
            }
            $data['Attr4']['form_params'] = implode(';', $form_params);
        }

        if (isset($data['Attr1']['form_sqlselect']) && !empty($data['Attr1']['form_sqlselect'])) {
            $data['Attr1']['form_sqlselect'] = strtr($data['Attr1']['form_sqlselect'], $this->arr_to_replace['others']['mixTableFields']);
            $data['Attr1']['form_sqlselect'] = strtr($data['Attr1']['form_sqlselect'], $this->arr_to_replace['others']['fix_fix_replace']);
            $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_notification']['profile']['tabela_conn']);
            if(nm_db_type($arr_conn['dbms']) == 'mssql'){
                $data['Attr4']['comando_select_edit'] = strtr($data['Attr4']['comando_select_edit'], ["'[usr_login]'" => '"[usr_login]"']);
            }
        }
        if (isset($data['Attr2']) && isset($data['Attr2']['botoes'])) {

            foreach ($data['Attr2']['botoes'] as $k => $v) {
                $data['Attr2']['botoes'][$k]['js'] = strtr($data['Attr2']['botoes'][$k]['js'], array('nmapp_' => $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app']) );
                $data['Attr2']['botoes'][$k]['js'] = strtr($data['Attr2']['botoes'][$k]['js'], $this->arr_to_replace['others']['protected_fields']);
                $data['Attr2']['botoes'][$k]['js'] = strtr($data['Attr2']['botoes'][$k]['js'], $this->arr_to_replace['others']['protected_var']);
            }

        }

        $data['Attr1']['security_url_redirect'] = $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app'] . "Login";
        $data['Attr1']['doc_path'] = substr($nm_config['path_root'], 0, -1) . $nm_ini_sys->GetTag('path_doc');

        $data['Attr4']['imagem_path'] = $nm_ini_sys->GetTag('path_img');
        if (isset($data['Attr1']['unique_key']) && !empty($data['Attr1']['unique_key'])) {
            $unique_key = explode(';', $data['Attr1']['unique_key']);
            foreach ($unique_key as $k => $uni) {
                if (isset($this->arr_to_replace['others']['mixTableFields'][$data['NomeTabela'] . "." . $uni])) {
                    $unique_key[$k] = $this->arr_to_replace['others']['mixTableFields'][$data['NomeTabela'] . "." . $uni];
                } else {
                    $unique_key[$k] = strtr($uni, $this->arr_to_replace['campos'][$data['NomeTabela']]);
                }
            }
            $data['Attr1']['unique_key'] = implode(';', $unique_key);
        }
        /*
                if (isset($data['Attr3']['dependency_new']) && is_array($data['Attr3']['dependency_new'])) {
                    foreach ($data['Attr3']['dependency_new'] as $k => $arr_dep) {

                        foreach ($data['Attr3']['dependency_new'][$k]['fld_pri'] as $k_fld => $fld) {
                            $data['Attr3']['dependency_new'][$k]['fld_pri'][$k_fld] = strtr($data['Attr3']['dependency_new'][$k]['fld_pri'][$k_fld], $this->arr_to_replace['campos'][$data['NomeTabela']]);
                        }
                        foreach ($data['Attr3']['dependency_new'][$k]['fld_dep'] as $k_fld => $fld) {
                            $data['Attr3']['dependency_new'][$k]['fld_dep'][$k_fld] = strtr($data['Attr3']['dependency_new'][$k]['fld_dep'][$k_fld], $this->arr_to_replace['campos'][$data['Attr3']['dependency_new'][$k]['name']]);
                        }
                        $data['Attr3']['dependency_new'][$k]['name'] = $this->arr_to_replace['tabelas'][$data['Attr3']['dependency_new'][$k]['name']];
                    }
                }*/

        if (isset($data['Attr2']['blocos']) && is_array($data['Attr2']['blocos'])) {
            foreach ($data['Attr2']['blocos'] as $k => $bloco) {
                if (!empty($data['NomeTabela']) && count($bloco['campos']) > 0) {
                    foreach ($bloco['campos'] as $seq => $field) {
                        $data['Attr2']['blocos'][$k]['campos'][$seq] = isset($this->arr_to_replace['campos'][$data['NomeTabela']][$field]) ? $this->arr_to_replace['campos'][$data['NomeTabela']][$field] : $data['Attr2']['blocos'][$k]['campos'][$seq];
                    }
                }

                $data['Attr2']['blocos'][$k]['t_nome'] = (substr($data['Attr2']['blocos'][$k]['t_nome'], 6) == 'nmapp_')
                    ? $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app'] . substr($data['Cod_Apl'], 6) : $data['Attr2']['blocos'][$k]['t_nome'];
                $data['Attr2']['blocos'][$k]['t_texto'] = (substr($data['Attr2']['blocos'][$k]['t_texto'], 6) == 'nmapp_')
                    ? $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app'] . substr($data['Attr2']['blocos'][$k]['t_texto'], 6) : $data['Attr2']['blocos'][$k]['t_texto'];

            }

        }
        if (isset($data['Attr2']['blocos_filter']) && is_array($data['Attr2']['blocos_filter'])) {
            foreach ($data['Attr2']['blocos_filter'] as $k => $bloco) {
                if (!empty($data['NomeTabela']) && count($bloco['campos']) > 0) {
                    foreach ($bloco['campos'] as $seq => $field) {
                        $data['Attr2']['blocos_filter'][$k]['campos'][$seq] = isset($this->arr_to_replace['campos'][$data['NomeTabela']][$field]) ? $this->arr_to_replace['campos'][$data['NomeTabela']][$field] : $data['Attr2']['blocos_filter'][$k]['campos'][$seq];
                    }
                }
                $data['Attr2']['blocos_filter'][$k]['t_nome'] = (substr($data['Attr2']['blocos_filter'][$k]['t_nome'], 6) == 'nmapp_')
                    ? $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app'] . substr($data['Cod_Apl'], 6) : $data['Attr2']['blocos_filter'][$k]['t_nome'];

                $data['Attr2']['blocos_filter'][$k]['t_texto'] = (substr($data['Attr2']['blocos_filter'][$k]['t_texto'], 6) == 'nmapp_') ?
                    $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app'] . substr($data['Attr2']['blocos_filter'][$k]['t_texto'], 6) : $data['Attr2']['blocos_filter'][$k]['t_texto'];

            }

        }

        if (!empty($data['NomeTabela'])) {
            $data['NomeTabela'] = $this->arr_to_replace['tabelas'][$data['NomeTabela']] ?? $data['NomeTabela'];
        }

        if (!empty($data['ComandoSelect']) && $data['Cod_Apl'] != 'nmapp_menu') {
            $data['ComandoSelect'] = strtr($data['ComandoSelect'], $this->arr_to_replace['tabelas']);
            $data['ComandoSelect'] = strtr($data['ComandoSelect'], $this->arr_to_replace['others']['fix_fix_replace']);
        }
        if (!empty($data['Attr1']) && !empty($data['Attr1']['form_sqlwhere'])) {
            $data['Attr1']['form_sqlwhere'] = strtr($data['Attr1']['form_sqlwhere'], $this->arr_to_replace['tabelas']);
            $data['Attr1']['form_sqlwhere'] = strtr($data['Attr1']['form_sqlwhere'], $this->arr_to_replace['others']['fix_fix_replace']);
        }

        if (!empty($data['Attr2']) && $data['Cod_Apl'] == 'nmapp_menu') {
            $navmenu_itens = json_decode($data['Attr2']['navmenu_itens'], true);
            $navmenu_itens['items'] = $this->normalizeMenu($navmenu_itens['items'], 2);
            $data['Attr2']['navmenu_itens'] = json_encode($navmenu_itens);
        }

        if ($data['Cod_Apl'] == 'nmapp_menu' && $_SESSION['nm_session']['module_notification']['profile']['config_general']['menu'] == 'new_menu') {
            $data_nmapp_menu = json_decode($data['Attr2']['navmenu_itens'], true);
            $data_nmapp_menu['theme'] = $_SESSION['nm_session']['module_notification']['profile']['config_general']['menu_theme'];
            $data_nmapp_menu['layout'] = strtoupper($_SESSION['nm_session']['module_notification']['profile']['config_general']['menu_layout']);
            $data['Attr2']['navmenu_itens'] = json_encode($data_nmapp_menu);
        }

        switch ($data['Tipo_Apl']) {
            case NM_APP_TYPE_CALENDAR:
            case NM_APP_TYPE_FORM:
                $data['Attr3']["log_events"] = array_intersect(array('access', 'insert', 'update', 'delete'), $this->arr_to_replace['sc_tbapl']['Attr3']['log_events']);
                break;
            default:
                $data['Attr3']["log_events"] = array_intersect(array('access'), $this->arr_to_replace['sc_tbapl']['Attr3']['log_events']);
                break;
        }

        if (isset($data['Attr3']['ligacoes'][0]) && is_array($data['Attr3']['ligacoes'][0])) {
            $arr_mix = array();

            foreach ($this->arr_to_replace['campos'] as $arr) {
                if (!is_array($arr)) continue;
                $arr_mix = array_merge($arr_mix, $arr);
            }

            foreach ($data['Attr3']['ligacoes'] as $k => $liga) {
                $data['Attr3']['ligacoes'][$k]['liga_apl'] = $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app'] . substr($data['Attr3']['ligacoes'][$k]['liga_apl'], 6);
                if (substr($data['Attr3']['ligacoes'][$k]['liga_id'], 0, 4) == 'apl_') {
                    $data['Attr3']['ligacoes'][$k]['liga_id'] = "apl_" . $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app'] . substr($data['Attr3']['ligacoes'][$k]['liga_id'], 10);
                }
                $data['Attr3']['ligacoes'][$k]['liga_parms'] = strtr($liga['liga_parms'], $this->arr_to_replace['others']['mixTableFields']);
                $data['Attr3']['ligacoes'][$k]['liga_parms'] = strtr($liga['liga_parms'], $this->arr_to_replace['others']['fix_fix_replace']);
            }
        }

        if (isset($data['Attr3']['toolbars']['bottom_center'])) {
            $arr_remove_social = [];
            $__var = $_SESSION['nm_session']['module_notification']['profile']['config_general'];
            if (!isset($__var['option_google']) || (isset($__var['option_google']) && $__var['option_google'] != 'google')) {
                $arr_remove_social[] = 'sys_auth_google';
            }
            if (!isset($__var['option_twitter']) || (isset($__var['option_twitter']) && $__var['option_twitter'] != 'twitter')) {
                $arr_remove_social[] = 'sys_auth_twitter';
            }
            if (!isset($__var['option_facebook']) || (isset($__var['option_facebook']) && $__var['option_facebook'] != 'facebook')) {
                $arr_remove_social[] = 'sys_auth_facebook';
            }
            $data['Attr3']['toolbars']['bottom_center'] = array_diff($data['Attr3']['toolbars']['bottom_center'], $arr_remove_social);
            if (isset($data['Attr3']['toolbars']['mobile_bottom_center'])) {
                $data['Attr3']['toolbars']['mobile_bottom_center'] = array_diff($data['Attr3']['toolbars']['mobile_bottom_center'], $arr_remove_social);
            }
        }

        $data['Attr4']['usa_ajax'] = ($data['Tipo_Apl'] == NM_APP_TYPE_GRID ? 'S' : 'N');

        $data['Cod_Apl'] = $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app'] . substr($data['Cod_Apl'], 6);
        return $data;
    } // normalizeApplication

    function replace($table, $data)
    {
        foreach ($this->arr_to_replace[$table] as $str_name => $campo) {
            if (!is_array($campo)) {
                $data[$str_name] = $campo;
            } else {
                foreach ($campo as $k => $v) {
                    $data[$str_name][$k] = $v;
                }
            }
        }
        return $data;
    }

    function inserData($nm_db_usu)
    {
        global $nm_config;
        $charset = $this->getCharset();
        $old_error_handler = set_error_handler("nm_faz_nada");
        if (
            isset($_SESSION['nm_session']['module_notification']['profile']['pop_app']['include_apps'])
            && $_SESSION['nm_session']['module_notification']['profile']['pop_app']['include_apps'] == 'Y'
        ) {


            $prefix = $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app'];

            //$data[] = array(0 => $prefix . "get_notif_counter", 5 => 'blank', 3 => 'Notification :: Counter of notifications');
            $data[] = array(0 => $prefix . "form_sec_notif_inbox_tags", 5 => 'form', 3 => 'NOTIFICATIONS MODULE :: Associate notification with tag');
            $data[] = array(0 => $prefix . "form_notiftable_user_tags", 5 => 'form', 3 => 'NOTIFICATIONS MODULE :: Create/Edit tags saved to users');
            $data[] = array(0 => $prefix . "form_sec_notif_tags", 5 => 'form', 3 => 'NOTIFICATIONS MODULE :: Create and edit Tags');
            $data[] = array(0 => $prefix . "form_sec_notifications", 5 => 'form', 3 => 'NOTIFICATIONS MODULE :: Send Message');
            $data[] = array(0 => $prefix . "form_sec_notif_pref", 5 => 'form', 3 => 'NOTIFICATIONS MODULE :: Preferencias');
            $data[] = array(0 => $prefix . "form_notif_profiles", 5 => 'form', 3 => 'NOTIFICATIONS MODULE :: Create and edit Profiles');
            $data[] = array(0 => $prefix . "grid_notif_user_tags", 5 => 'cons', 3 => 'NOTIFICATIONS MODULE :: Tags saved to users');
            $data[] = array(0 => $prefix . "grid_sec_notif_inbox", 5 => 'cons', 3 => 'NOTIFICATIONS MODULE :: View message inbox');
            $data[] = array(0 => $prefix . "grid_sec_notif_read", 5 => 'cons', 3 => 'NOTIFICATIONS MODULE :: Read message');
            $data[] = array(0 => $prefix . "grid_sec_notif_outbox", 5 => 'cons', 3 => 'NOTIFICATIONS MODULE :: View sent messages');
            $data[] = array(0 => $prefix . "grid_sec_notif_outbox_sub", 5 => 'cons', 3 => 'NOTIFICATIONS MODULE :: View details of sent messages');
            if ($_SESSION['nm_session']['module_notification']['profile']['config_general']['menu'] == 'new_menu') {
                $data[] = array(0 => $prefix . "menu", 5 => 'menu', 3 => 'NOTIFICATIONS MODULE :: Menu');
            }
            $arr_sqls = array();
            if(!empty($_SESSION['nm_session']['module_notification']['profile']['pop_app']['table_app'])){
                foreach($data as $k => $v){
                    $sql = "INSERT INTO " . $_SESSION['nm_session']['module_notification']['profile']['pop_app']['table_app'] . " (app_name, app_type, description) VALUES ("
                        . $nm_db_usu->qstr($v[0]) . ", "
                        . $nm_db_usu->qstr($v[5]) . ", "
                        . $nm_db_usu->qstr($v[3]) . ")";
                    $nm_db_usu->Execute($sql);
                    $arr_sqls[] = $sql . ' :: '.$nm_db_usu->ErrorMsg();
                }
            }

            $y = $nm_db_usu->qstr("Y");
            $n = $nm_db_usu->qstr("N");
            $perms = array();
            $perms[NM_APP_TYPE_GRID] = ", " . $y . ", " . $n . ", " . $n . ", " . $n . ", " . $y . ", " . $y;
            $perms[NM_APP_TYPE_FORM] = ", " . $y . ", " . $y . ", " . $y . ", " . $y . ", " . $n . ", " . $n;
            $perms[NM_APP_TYPE_FILTER] = ", " . $y . ", " . $n . ", " . $n . ", " . $n . ", " . $n . ", " . $n;
            $perms[NM_APP_TYPE_CONTROL] = $perms[NM_APP_TYPE_FILTER];
            $perms[NM_APP_TYPE_MENU] = $perms[NM_APP_TYPE_FILTER];
            $no_perm = ", " . $n . ", " . $n . ", " . $n . ", " . $n . ", " . $n . ", " . $n;

            $arr_apps_open = array(
                $prefix ."grid_sec_notif_inbox",
                $prefix ."grid_sec_notif_read",
                $prefix ."form_sec_notif_inbox_tags",
                $prefix ."form_sec_notif_tags",
                $prefix ."form_sec_notif_pref",
                $prefix ."grid_notif_user_tags",
                $prefix ."form_notiftable_user_tags",
            );
            if($_SESSION['nm_session']['module_notification']['profile']['pop_app']['table_usr_grp_app'] != '@@no-table@@') {
                if ($_SESSION['nm_session']['module_notification']['profile']['usr_grp'] == 'grp') {
                    $sql = nm_decode_utf8_charset("SELECT " . $_SESSION['nm_session']['module_notification']['profile']['table_grp_field_group_id'] . " FROM " . $_SESSION['nm_session']['module_notification']['profile']['table_grp'], $charset);

                    $rs = $nm_db_usu->Execute($sql);
                    $arr_sqls[] = $sql . ' :: '.$nm_db_usu->ErrorMsg();
                    if (isset($rs->fields[0])) {
                        while (!$rs->EOF) {
                            foreach ($data as $v) {
                                $perm = $no_perm;
                                if ($rs->fields[0] == 1 || in_array($v[0],$arr_apps_open)) {
                                    $perm = $perms[$v[5]];
                                }

                                $sql = nm_decode_utf8_charset("INSERT INTO " . $_SESSION['nm_session']['module_notification']['profile']['pop_app']['table_usr_grp_app']
                                    . "(group_id,app_name, priv_access, priv_insert, priv_delete, priv_update, priv_export, priv_print)
                         VALUES (" . $nm_db_usu->qstr($rs->fields[0]) . ", " . $nm_db_usu->qstr($v[0]) . $perm . ")", $charset);
                                $nm_db_usu->Execute($sql);
                                $arr_sqls[] = $sql. ' :: '.$nm_db_usu->ErrorMsg();
                            }
                            $rs->MoveNext();
                        }
                        $rs->Close();
                    }
                }
                else{
                    $sql = nm_decode_utf8_charset("SELECT " . $_SESSION['nm_session']['module_notification']['profile']['table_usr_field_login'] . " FROM " . $_SESSION['nm_session']['module_notification']['profile']['table_usr'], $charset);
                    $rs = $nm_db_usu->Execute($sql);
                    $arr_sqls[] = $sql. ' :: '.$nm_db_usu->ErrorMsg();
                    if (isset($rs->fields[0])) {
                        while (!$rs->EOF) {
                            foreach ($data as $v) {
                                $perm = $no_perm;
                                if ($rs->fields[0] == 'admin' || !in_array($v[0],$arr_apps_open)) {
                                    $perm = $perms[$v[5]];
                                }

                                $sql = nm_decode_utf8_charset("INSERT INTO " . $_SESSION['nm_session']['module_notification']['profile']['pop_app']['table_usr_grp_app']
                                    . "(login,app_name, priv_access, priv_insert, priv_delete, priv_update, priv_export, priv_print)
                         VALUES (" . $nm_db_usu->qstr($rs->fields[0]) . ", " . $nm_db_usu->qstr($v[0]) . $perm . ")", $charset);
                                $nm_db_usu->Execute($sql);
                                $arr_sqls[] = $sql. ' :: '.$nm_db_usu->ErrorMsg();
                            }
                            $rs->MoveNext();
                        }
                        $rs->Close();
                    }
                }
            }

        }
//tabela_seg_prefix
        $rs = $nm_db_usu->Execute(nm_decode_utf8_charset("SELECT " . $_SESSION['nm_session']['module_notification']['profile']['table_usr_field_login'] . " FROM " . $_SESSION['nm_session']['module_notification']['profile']['table_usr'], $charset));
        $sms = !empty($_SESSION['nm_session']['module_notification']['profile']['config_general']['sms_api']) ?
            ',1' : '';
        $email = !empty($_SESSION['nm_session']['module_notification']['profile']['config_general']['smtp_api']) ?
            ',1' : '';
        $sms_field = !empty($_SESSION['nm_session']['module_notification']['profile']['config_general']['sms_api']) ?
            ', ' . $_SESSION['nm_session']['module_notification']['profile']['pref']['receive_sms'] : '';
        $email_field = !empty($_SESSION['nm_session']['module_notification']['profile']['config_general']['smtp_api']) ?
            ', ' . $_SESSION['nm_session']['module_notification']['profile']['pref']['receive_email'] : '';

        if (isset($rs->fields[0])) {
            while (!$rs->EOF) {
                $sql = nm_decode_utf8_charset("INSERT INTO " . $_SESSION['nm_session']['module_notification']['profile']['pref']['table']
                    . "(" . $_SESSION['nm_session']['module_notification']['profile']['pref']['login']
                    . $email_field
                    . $sms_field . ") VALUES (" . $nm_db_usu->qstr($rs->fields[0]) .  $email . $sms . ")", $charset);
                $nm_db_usu->Execute($sql);
                $arr_sqls[] = $sql. ' :: '.$nm_db_usu->ErrorMsg();
                $rs->MoveNext();
            }
        }
        $rs->Close();

        if($nm_config['em_desenv']){
            file_put_contents($nm_config['path_tmp'] . "debug_sql_module_notification_" . md5(date('YmdHis')) . ".sql", implode(";\n\n\n", $arr_sqls), FILE_APPEND);
        }
        set_error_handler($old_error_handler);
    }

    function normalizeField($data, $app_table)
    {
        global $nm_config;
        $data = $this->replace('sc_tbcmp', $data);

        if ($data['Attr1']['banco_val_tipo'] == 'inc_auto') {

            $conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_notification']['profile']['tabela_conn']);

            nm_load_class('interface', 'Group');
            $obj_group = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
            $force_utf8 = ($obj_group->GetData('force_db_utf8') == 'S');

            $nm_db_usu = nm_db_connect($conn, __FILE__, __LINE__, true, "", $force_utf8);
            $str_conn = $_SESSION['nm_session']['module_notification']['profile']['tabela_conn'];
            if(isset($_SESSION['nm_session']['cache']['tables_fields_meta_columns'][ $str_conn ])){
                unset($_SESSION['nm_session']['cache']['tables_fields_meta_columns'][ $str_conn ]);
            }
            if(isset($_SESSION['nm_session']['cache']['tables_fields_ai'][ $str_conn ])){
                unset($_SESSION['nm_session']['cache']['tables_fields_ai'][ $str_conn ]);
            }
            if(is_dir($nm_config['path_log'] .'cache/'. $_SESSION['nm_session']['user']['cod_grp'])){
                nm_dir_delete($nm_config['path_log'] . "cache/". $_SESSION['nm_session']['user']['cod_grp']);
                nm_dir_create($nm_config['path_log'] . "cache/". $_SESSION['nm_session']['user']['cod_grp']);
            }
            $chave = nm_db_fields_ai($str_conn, $this->arr_to_replace['campos'][$app_table]['table'], $nm_db_usu, $this->obj_con);
            $data['Attr1']['autoinc_nome'] = $chave[$data['Campo_Def']] ?? $chave[strtoupper($data['Campo_Def'])];
            if(
                isset($_SESSION['nm_session']['module_notification']['oracle11']) &&
                $_SESSION['nm_session']['module_notification']['oracle11'] == true
            ){
                $_SESSION['nm_session']['module_notification']['oracle11_inc_auto'] = true;
                if(empty($data['Attr1']['autoinc_nome'])) {
                    $data['Attr1']['banco_val_tipo'] = 'inc_man';
                    $_SESSION['nm_session']['module_notification']['oracle11_inc_auto'] = false;
                }
            }
        }

        if ($_SESSION['nm_session']['module_notification']['profile']['usr_grp'] == 'usr') {
            if ($data['Cod_Apl'] == 'nmapp_form_sec_notifications' &&
                strtolower($data['Campo']) == 'sendtogroup') {
                return false;
            }
            if (
                isset($_SESSION['nm_session']['module_notification']['profile']['pop_app']['include_apps']) &&
                $_SESSION['nm_session']['module_notification']['profile']['pop_app']['include_apps'] != 'Y' &&
                $data['Cod_Apl'] == 'nmapp_form_sec_notifications' &&
                strtolower($data['Campo']) == 'notif_link') {
                $data['Tipo_Dado'] = 'TEXTO';
            }
            if ($data['Cod_Apl'] == 'nmapp_form_notif_profiles' &&
                strtolower($data['Campo']) == 'profile_groups') {
                return false;
            }
        }

        $arr_mix = array();
        foreach ($this->arr_to_replace['campos'] as $arr) {
            if (!is_array($arr)) continue;
            $arr_mix = array_merge($arr_mix, $arr);
        }
        $data['Texto_Xml'] = isset($this->arr_to_replace['others'][$data['Cod_Apl']][$data['Campo']]['Texto_Xml']) ? $this->arr_to_replace['others'][$data['Cod_Apl']][$data['Campo']]['Texto_Xml'] : $data['Texto_Xml'];
        $data['Attr4']['tam_minimo'] = isset($data['Campo']) && isset($this->arr_to_replace['others'][$data['Cod_Apl']][$data['Campo']]['Tam_Minimo']) ? $this->arr_to_replace['others'][$data['Cod_Apl']][$data['Campo']]['Tam_Minimo'] : $data['Attr4']['tam_minimo'];
        $data['Attr4']['tam_maximo'] = isset($data['Campo']) && isset($this->arr_to_replace['others'][$data['Cod_Apl']][$data['Campo']]['Tam_Maximo']) ? $this->arr_to_replace['others'][$data['Cod_Apl']][$data['Campo']]['Tam_Maximo'] : $data['Attr4']['tam_maximo'];
        if (isset($data['Attr4']['signature_guideline'])) {
            unset($data['Attr4']['signature_guideline']);
        }

        $data['Campo'] = (isset($data['Campo_Def']) && isset($this->arr_to_replace['campos'][$app_table][$data['Campo']])) ? strtr($this->arr_to_replace['campos'][$app_table][$data['Campo']], array("'" => "", '"' => "", "[" => "", "]" => "", "`" => "")) : $data['Campo'];

        if (isset($data['Def_Campo'])) {
            if (isset($this->arr_to_replace['campos'][$app_table][$data['Def_Campo']])) {
                $data['Def_Campo'] = $this->arr_to_replace['campos'][$app_table][$data['Def_Campo']];
            } else {
                $app_field = strtr($data['Def_Campo'], [$app_table . '.' => '']);
                if (isset($this->arr_to_replace['campos'][$app_table][$app_field])) {
                    $data['Def_Campo'] = $this->arr_to_replace['campos'][$app_table]['table'] . '.' . $this->arr_to_replace['campos'][$app_table][$app_field];
                } else {
                    $__tmp = explode('.', $data['Def_Campo']);
                    if (isset($this->arr_to_replace['campos'][$__tmp[0]][$__tmp[1]])) {
                        $data['Def_Campo'] = $this->arr_to_replace['campos'][$__tmp[0]]['table'] . '.' . $this->arr_to_replace['campos'][$__tmp[0]][$__tmp[1]];
                    }
                }
            }
        }
        if (isset($data['Campo_Def'])) {
            if (isset($this->arr_to_replace['campos'][$app_table][$data['Campo_Def']])) {
                $data['Campo_Def'] = $this->arr_to_replace['campos'][$app_table][$data['Campo_Def']];
            } else {
                $app_field = strtr($data['Campo_Def'], [$app_table . '.' => '']);
                if (isset($this->arr_to_replace['campos'][$app_table][$app_field])) {
                    $data['Campo_Def'] = $this->arr_to_replace['campos'][$app_table]['table'] . '.' . $this->arr_to_replace['campos'][$app_table][$app_field];
                } else {
                    $__tmp = explode('.', $data['Campo_Def']);
                    if (isset($this->arr_to_replace['campos'][$__tmp[0]][$__tmp[1]])) {
                        $data['Campo_Def'] = $this->arr_to_replace['campos'][$__tmp[0]]['table'] . '.' . $this->arr_to_replace['campos'][$__tmp[0]][$__tmp[1]];
                    }
                }
            }
        }
        $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_notification']['profile']['tabela_conn']);

        //$data['Campo_Def'] = (isset($data['Campo_Def']) && isset($this->arr_to_replace['campos'][$app_table][$data['Campo_Def']])) ? $this->arr_to_replace['campos'][$app_table][$data['Campo_Def']] : $data['Campo_Def'];
        $data['Def_Tabela'] = (isset($this->arr_to_replace['tabelas'][$app_table]) ? $this->arr_to_replace['tabelas'][$app_table] : $data['Def_Tabela']);
        $data['Attr4']['comando_select_edit'] = strtr($data['Attr4']['comando_select_edit'], $this->arr_to_replace['others']['mixTableFields']);
        $data['Attr4']['comando_select_edit'] = strtr($data['Attr4']['comando_select_edit'], $this->arr_to_replace['others']['fix_fix_replace']);
        if(nm_db_type($arr_conn['dbms']) == 'mssql'){
            $data['Attr4']['comando_select_edit'] = strtr($data['Attr4']['comando_select_edit'], ["'[usr_login]'" => '"[usr_login]"']);
        }
        if (isset($data['Attr1']['lookup_tab_nome']) && !empty($data['Attr1']['lookup_tab_nome'])) {
            $data['Attr1']['lookup_cmp_lista'] = strtr($data['Attr1']['lookup_cmp_lista'], $this->arr_to_replace['campos'][$data['Attr1']['lookup_tab_nome']]);

            if (nm_db_type($arr_conn['dbms']) == 'postgres') {
                $data['Attr1']['lookup_tab_nome'] = trataCampoTabela($this->arr_to_replace['tabelas'][$data['Attr1']['lookup_tab_nome']], $arr_conn['dbms']);
            } else {
                $data['Attr1']['lookup_tab_nome'] = $this->arr_to_replace['tabelas'][$data['Attr1']['lookup_tab_nome']];
            }
        }

        if ($_SESSION['nm_session']['module_notification']['profile']['usr_grp'] == 'usr' &&
            $data['Cod_Apl'] == 'nmapp_form_sec_notifications' &&
            strtolower($data['Campo']) == 'f_type' &&
            isset($data['Def_Complemento']['conteudo'])
        ) {
            $arr_new = array();
            foreach ($data['Def_Complemento']['conteudo'] as $__data) {
                if ($__data['value_lig'] == 1) {
                    continue;
                }
                $arr_new[] = $__data;
            }
            $data['Def_Complemento']['conteudo'] = $arr_new;
        }
        if (isset($data['Def_Complemento']['select']) && !empty($data['Def_Complemento']['select'])) {
            $data['Def_Complemento']['select'] = strtr($data['Def_Complemento']['select'], $this->arr_to_replace['others']['mixTableFields']);
            $data['Def_Complemento']['select'] = strtr($data['Def_Complemento']['select'], $this->arr_to_replace['others']['fix_fix_replace']);
            //$data['Def_Complemento']['select']		= strtr($data['Def_Complemento']['select'], $arr_mix);
        }

        if (isset($data['Def_Complemento_Cons']['select']) && !empty($data['Def_Complemento_Cons']['select'])) {
            $data['Def_Complemento_Cons']['select'] = strtr($data['Def_Complemento_Cons']['select'], $this->arr_to_replace['others']['mixTableFields']);
            $data['Def_Complemento_Cons']['select'] = strtr($data['Def_Complemento_Cons']['select'], $this->arr_to_replace['others']['fix_fix_replace']);
            //$data['Def_Complemento_Cons']['select']		= strtr($data['Def_Complemento_Cons']['select'], $arr_mix);
        }

        if (isset($data['Def_Complemento_Pesq']['select']) && !empty($data['Def_Complemento_Pesq']['select'])) {
            $data['Def_Complemento_Pesq']['select'] = strtr($data['Def_Complemento_Pesq']['select'], $this->arr_to_replace['others']['mixTableFields']);
            $data['Def_Complemento_Pesq']['select'] = strtr($data['Def_Complemento_Pesq']['select'], $this->arr_to_replace['others']['fix_fix_replace']);
            //$data['Def_Complemento_Pesq']['select']		= strtr($data['Def_Complemento_Pesq']['select'], $arr_mix);
        }

        if (in_array(strtolower($data['Campo']), array('picture'))) {
            $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_notification']['profile']['tabela_conn']);
            switch (nm_db_type($arr_conn['dbms'])) {
                case 'access' :
                    $tipo_sql = 'LONGBINARY';
                    break;
                case 'postgres' :
                    $tipo_sql = 'BYTEA';
                    break;
                case 'oracle' :
                    $tipo_sql = 'BLOB';
                    break;
                case 'mssql' :
                    $tipo_sql = 'BINARY';
                    break;
                default:
                    $tipo_sql = $data['Tipo_Sql'];
                    break;
            }
            $data['Tipo_Sql'] = $tipo_sql;
        }
        if (in_array(strtolower($data['Campo']), array('notif_message', 'profile_groups', 'profile_users'))) {
            $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_notification']['profile']['tabela_conn']);
            $tipo_sql = $data['Tipo_Sql'];
            switch (nm_db_type($arr_conn['dbms'])) {
                case 'postgres' :
                    if('notif_message' == strtolower($data['Campo'])){
                        $tipo_sql = 'TEXT';
                    }
//                    $data['Attr1']['form_text_js_code'] = "S";
//                    $tipo_sql = 'BYTEA';
//                    break;
                break;
                case 'oracle' :
                    $tipo_sql = 'CLOB';
                    break;
            }
            $data['Tipo_Sql'] = $tipo_sql;
        }

        $data['Cod_Apl'] = $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app'] . substr($data['Cod_Apl'], 6);

        return $data;
    }

    function normalizeEvent($data)
    {
        global $nm_config;
        $config = $_SESSION['nm_session']['module_notification']['profile']['config_general'];
        $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_notification']['profile']['tabela_conn']);

        $config_email = $_SESSION['nm_session']['module_notification']['profile']['config_email'] ?? '';
        $data = $this->replace('sc_tbevt', $data);
        if (!isset($config['criptografia']) || empty($config['criptografia'])) {
            $data['Codigo'] = str_replace('md5(', '(', $data['Codigo']);
        } else {
            $data['Codigo'] = str_replace('md5(', 'hash("' . $config['criptografia'] . '",', $data['Codigo']);
        }
        if(isset($_SESSION['nm_session']['module_notification']['oracle11']) &&
            $_SESSION['nm_session']['module_notification']['oracle11'] && !$_SESSION['nm_session']['module_notification']['oracle11_inc_auto']){
            $data['Codigo'] = strtr($data['Codigo'], [
                '$ins_sql = "INSERT INTO notiftable_inbox (notiftable_inbox.notif_id, notiftable_inbox.login, notiftable_inbox.notif_tags, notiftable_inbox.notif_ontop, notiftable_inbox.notif_dtsent) VALUES (".{notif_id}.", " .sc_sql_injection($rs->fields[0]).",0, ".$on_top.", ". sc_sql_injection({notif_dtcreated}) .")";' =>
                '$last_id = sc_lookup(rs_last_id, "SELECT NVL(MAX(notiftable_inbox.inbox_id), 0) FROM notiftable_inbox"); 
        $ins_sql = "INSERT INTO notiftable_inbox (notiftable_inbox.inbox_id, notiftable_inbox.notif_id, notiftable_inbox.login, notiftable_inbox.notif_tags, notiftable_inbox.notif_ontop, notiftable_inbox.notif_dtsent) VALUES (".( (int){rs_last_id[0][0]} + 1).",".{notif_id}.", " .sc_sql_injection($rs->fields[0]).",0, ".$on_top.", ". sc_sql_injection({notif_dtcreated}) .")";',

                '$ins_sql = "INSERT INTO notiftable_inbox (notiftable_inbox.notif_id, notiftable_inbox.login, notiftable_inbox.notif_tags,notiftable_inbox.notif_ontop, notiftable_inbox.notif_dtsent) VALUES (".{notif_id}.", " .sc_sql_injection($key).", 0, ".$on_top.", ". sc_sql_injection({notif_dtcreated}) .")";' =>
                '$last_id = sc_lookup(rs_last_id, "SELECT NVL(MAX(notiftable_inbox.inbox_id), 0) FROM notiftable_inbox"); 
        $ins_sql = "INSERT INTO notiftable_inbox (notiftable_inbox.inbox_id, notiftable_inbox.notif_id, notiftable_inbox.login, notiftable_inbox.notif_tags,notiftable_inbox.notif_ontop, notiftable_inbox.notif_dtsent) VALUES (".( (int){rs_last_id[0][0]} + 1).",".{notif_id}.", " .sc_sql_injection($key).", 0, ".$on_top.", ". sc_sql_injection({notif_dtcreated}) .")";',

'$sql = "INSERT INTO notiftable_user_tags(notiftable_user_tags.login,notiftable_user_tags.login_sender, notiftable_user_tags.tags) VALUES (". sc_sql_injection({login})' =>
                '$last_id = sc_lookup(rs_last_id, "SELECT NVL(MAX(notiftable_user_tags.user_tags_id), 0) FROM notiftable_user_tags"); 
        		$sql = "INSERT INTO notiftable_user_tags(notiftable_user_tags.user_tags_id, notiftable_user_tags.login, notiftable_user_tags.login_sender, notiftable_user_tags.tags) VALUES (".( (int){rs_last_id[0][0]} + 1).",". sc_sql_injection({login})',


            ]);
        }

        if(  isset($_SESSION['nm_session']['module_notification']['profile']['pop_app']['include_apps']) &&
            $_SESSION['nm_session']['module_notification']['profile']['pop_app']['include_apps'] != 'Y'){
            $data['Codigo'] = strtr($data['Codigo'], ['sc_lookup(rs, "SELECT sec_apps.description 
FROM sec_apps 
WHERE sec_apps.app_name = \'{notif_link}\' 
ORDER BY sec_apps.description");
	{notif_link} = empty({rs[0][0]})? {notif_link} : {rs[0][0]};' => '']);
        }

        if (empty($config['smtp_api'])) {
            $data['Codigo'] = strtr($data['Codigo'], ['[sett_smtp] = array();' => 'return;']);
        } elseif ($config['smtp_api'] == 'same_of_security') {
            $data['Codigo'] = strtr($data['Codigo'], ['[sett_smtp] = array();' => '']);
        } elseif ($config['smtp_api'] == 'custom') {
            $data['Codigo'] = strtr($data['Codigo'], ['[sett_smtp] = array();' => "[sett_smtp] = array('settings' => array(
            'gateway'       => 'smtp',
			'smtp_server'   => '" . $config_email['smtp_server'] . "',
			'smtp_protocol' => '" . $config_email['smtp_security'] . "',
			'smtp_port'     => '" . $config_email['smtp_port'] . "',
			'smtp_user'     => '" . $config_email['smtp_user'] . "',
			'smtp_password' => '" . $config_email['smtp_pass'] . "',
			'from_email'    => '" . $config_email['smtp_email'] . "',
			'from_name'     => '" . $config_email['smtp_name'] . "',
            )
            );"]);
        } else {
            $data['Codigo'] = strtr($data['Codigo'], ['[sett_smtp] = array();'
            => "[sett_smtp] = array('profile' => '" . $config['smtp_api'] . "');"]);
        }
        if (empty($config['sms_api'])) {
            $data['Codigo'] = strtr($data['Codigo'], ["\$message = substr(0,140);" => "return;"]);
        }
        if (isset($_SESSION['nm_session']['module_notification']['profile']['config_sms'])) {
            $data['Codigo'] = strtr($data['Codigo'], ['sms_api' => $config['sms_api']]);
        }
        if (isset($_SESSION['nm_session']['module_notification']['profile']['config_sms']['qtd'])) {
            if (!empty($_SESSION['nm_session']['module_notification']['profile']['config_sms']['qtd'])) {
                $data['Codigo'] = strtr($data['Codigo'], ["\$message = substr(0,140);" => "\$message = substr(\$message, 0," . $_SESSION['nm_session']['module_notification']['profile']['config_sms']['qtd'] . ");"]);
            } else {
                $data['Codigo'] = strtr($data['Codigo'], ["\$message = substr(0,140);" => ""]);
            }
        }


        if (isset($config['menu']) && $config['menu'] != 'new_menu') {
            $arr_menu = explode('#@#', $config['menu']);
            $data['Codigo'] = strtr($data['Codigo'], array('nmapp_menu' => $arr_menu[0]));
        }


        $_arr_code = array_merge($this->arr_to_replace['others']['protected_fields'], array('nmapp_' => $config['prefix_app']));

        $_arr_code['NM@profile@NM'] = $_SESSION['nm_session']['module_notification']['profile']['perfil_save_name'];
        if ($_SESSION['nm_session']['module_notification']['profile']['usr_grp'] == 'usr' &&
            $data['Cod_Apl'] == 'nmapp_form_sec_notifications'
        ) {
            $_arr_code = array_merge($_arr_code, array(
                "sc_field_display({sendtogroup}, off);" => '',
                "sc_field_display({sendtogroup}, on);" => '',
                "send_to_inbox_groups();" => ''
            ));
        }

        if (in_array(nm_db_type($arr_conn['dbms']), array('sybase', 'access'))) {
            $_arr_code["sc_sql_injection({group_id})"] = "{group_id}";
            $_arr_code["sc_sql_injection([group]})"] = "[group]";
            $_arr_code["sc_sql_injection({group})"] = "{group}";
            $_arr_code["sc_sql_injection( [group] )"] = "[group]";
        }

        if ($data['Nome'] == 'active_onClick' && in_array(nm_db_type($arr_conn['dbms']), array('interbase', 'oracle'))) {
            $data['Nome'] = "ACTIVE_onClick";
        }

        $data['Codigo'] = strtr($data['Codigo'], $_arr_code);
        $data['Codigo'] = strtr($data['Codigo'], $this->arr_to_replace['others']['protected_var']);
        $data['Cod_Apl'] = $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app'] . substr($data['Cod_Apl'], 6);

        return $data;
    }


    function normalizeFolders()
    {
        nm_load_class('interface', 'Group');
        $obj_grp = new nmGroup($_SESSION['nm_session']['user']['cod_grp']);

        $_arr = $obj_grp->GetData('Folders');
        $_arr['root'][$_SESSION['nm_session']['module_notification']['profile']['config_general']['folder_notification']] = array();

        $obj_grp->SetData('Folders', $_arr);
        $obj_grp->AtuData($_SESSION['nm_session']['user']['cod_grp']);

        $_SESSION['nm_session']['user']['folder'] = $this->arr_to_replace['sc_tbapl']['Folder'];
    }

    /**
     * Exibe o conteudo.
     *
     * Exibe o conteudo da tela inicial do ScriptCase.
     *
     * @access  protected
     */
    function DisplayContent()
    {
        global $nm_template, $nm_config, $nm_db, $nm_ini_sys;
        //$this->load_variable_replace();
        //nm_printr($_SESSION['nm_session']['module_notification']['profile']['tipo_nivel'] ?? '');
        $this->showPageDesenv('module_notification');
        $nm_template->SetVar('noButton', ['carregar']);
        if (isset($_POST['action'])) {
            $this->do_action($_POST);
            $this->ChangeDisplay($_POST);
        } else {
            unset($_SESSION['nm_session']['module_notification']['profile']);

            $profiles = $this->LoadOptionProfile(true);

            if (count($profiles) == 0) {
                $i = 1;
                $nm_template->SetVar('block_image_help', $this->GetImgManual('module_notification_tipo_', NM_HELP_MENU_CONFIG));
                $nm_template->SetVar('noButton', ['carregar', 'tipo']);
            } else {
                $i = 0;
                $nm_template->SetVar('block_image_help', $this->GetImgManual('module_notification_carregar_', NM_HELP_MENU_CONFIG));
                $nm_template->SetVar('option_profile', $profiles);
            }
            $this->step_now = $this->arr_steps[$i];

            $nm_template->SetVar('step_before', (isset($this->arr_steps[$i - 1]) ? $this->arr_steps[$i - 1] : 0));
            $nm_template->SetVar('step_now', $this->step_now);
            $nm_template->SetVar('step_after', $this->arr_steps[$i + 1]);

            $this->ChangeDisplay(['action' => 'start']);
//            $nm_template->SetVar('content', "body_step_" . $this->step_now);
//            $nm_template->Display("body_base", 'module_notification');
        }
    }

    /**
     * Realiza uma ação de acordo com o passo.
     *
     * @param array $arr Array com POST
     *
     * @access  protected
     */
    function do_action($arr)
    {
        global $nm_config, $nm_template;
        if ($arr['action'] == 'next' || $arr['action'] == 'generate') {

            switch ($arr['step_now']) {
                case 'carregar':
                    if ($arr['profile'] == 'use') {
                        //$arr['option_profile'];
                        $arr_tmp_list_change = explode('#@NM@#', $arr['option_profile']);
                        list($level, $file_xml) = $arr_tmp_list_change;
                        switch ($level) {
                            case 'scriptcase':
                                $str_path = $nm_config['path_scriptcase'] . 'module_notification/';
                                break;
                            case 'sys':
                                $str_path = $nm_config['path_sys'] . 'module_notification/';
                                break;
                            case 'grp':
                                $str_path = $nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . '/module_notification/';
                                break;
                            case 'usr':
                                $str_path = $nm_config['path_usr'] . $_SESSION['nm_session']['user']['login'] . '/module_notification/';
                                break;
                        }
                        $arr = $this->source2array($str_path . $file_xml);
                        $_SESSION['nm_session']['module_notification']['profile'] = $arr;
                        $nm_template->SetVar('profile_nivel_in_use', $_SESSION['nm_session']['module_notification']['profile']['tipo_nivel']);
                    }
                    if (count($this->LoadOptionProfile(true)) == 0) {
                        $nm_template->SetVar('noButton', ['carregar', 'tipo']);
                    }
                    break;
                case 'tabela':
                    if (isset($arr['tabela_seg']) && $arr['tabela_seg'] == 'create') {
                        //beginTrans();
                        if (isset($arr['tabela_drop_tables']) && $arr['tabela_drop_tables'] == 'S') {

                            $this->DropTables($arr['tabela_conn'],
                                $arr['tabela_seg_prefix']);
                        }

                        list($sql_name, $ret, $arr_err) = $this->CreateTables($arr['tabela_conn'],
                            $arr['tabela_seg_prefix']);

                        //commitTrans();
                        $arr['tabela_seg_log_filename'] = $sql_name;
                        $_SESSION['nm_session']['module_notification']['profile']['tabela_seg_create_filename'] = $sql_name;
                        $nm_template->SetVar('create_table_log', $ret);
                        $nm_template->SetVar('create_table_file', $sql_name);
                        if (!empty($arr_err)) {
                            $_POST['step_after'] = 'tabela';
                            $str_error_lang = nm_get_text_lang("['app_error_title']");
                            $str_error = implode('', $arr_err);

                            $str_html = <<<HTML
                            <div class="ui modal tiny" id="err_tabela_create">
                                <div class="header">
                                    <h4>{$str_error_lang}</h4>
                                </div>
                                <div class="scrolling content">
                            		<span id="modal-info-span-description">{$str_error}</span>
                            	</div>
                                <div class="actions">
                                    <div class="ui primary button approve">
                                    	OK
                                    </div>
                                </div>
                            </div>

HTML;
                            $str_html .= <<<JS
                            <script>
                                $("#err_tabela_create").modal('show');
                            </script>
JS;
                            echo $str_html;

                        } else {
                            $_POST['step_after'] = 'config';
                        }

                    } else {
                        $conn = $this->obj_con->GetConnection($_REQUEST['tabela_conn'] ?? $_SESSION['nm_session']['module_notification']['profile']['tabela_conn']);

                        $db_type = nm_db_type($conn['dbms']);

                        nm_load_class('interface', 'Group');
                        $obj_group = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
                        $force_utf8 = ($obj_group->GetData('force_db_utf8') == 'S');

                        $this->SetSessionWithTables(
                            'notif_',
                            $db_type,
                            $this->returnLevelTables(),
                            $_REQUEST['tabela_conn'] ?? $_SESSION['nm_session']['module_notification']['profile']['tabela_conn'],
                            $conn,
                            $arr['tabela_seg'] != 'create');
                    }
                    break;

            }
        } else if ($arr['action'] == 'back') {
            switch ($arr['step_now']) {
                case 'config':
                    if (
                        ($_SESSION['nm_session']['module_notification']['profile']['tipo_nivel'] == 'ldap')
                        || ($arr['step_now'] == 'config' && $_SESSION['nm_session']['module_notification']['profile']['tabela_seg'] == 'create')
                    ) {
                        $_POST['step_before'] = 'tabela';
                        return;
                    }
                    break;
            }

            switch ($arr['step_before']) {
                case 'tipo':
                    if (count($this->LoadOptionProfile(true)) == 0) {
                        $nm_template->SetVar('noButton', ['carregar', 'tipo']);
                    }
                    break;
            }
        }
    }

    /**
     * Lê o arquivo xml e transforma em array.
     *
     * @param string source
     *
     * @access  protected
     */
    function source2array($source)
    {
        return unserialize(file_get_contents($source));
    }

    /**
     * Apaga as Tabelas, caso existirem.
     *
     *
     * @access  protected
     * @global  array $nm_config Array com configuracao do ScriptCase.
     */
    function DropTables($str_db, $prefix_table = 'notif_')
    {
        global $nm_config;

        nm_load_class('interface', 'DbInterface');
        $arr_tables = $this->returnLevelTables();
        krsort($arr_tables);

        $previous_error = set_error_handler("nm_faz_nada");

        $prefix_table = nm_decode_utf8_charset($prefix_table, $this->getCharset());

        nm_load_class('interface', 'Group');
        $obj_group = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
        $force_utf8 = ($obj_group->GetData('force_db_utf8') == 'S');

        $conn = $this->obj_con->GetConnection($str_db);
        $nm_db_usu = nm_db_connect($conn, __FILE__, __LINE__, true, "", $force_utf8);
        $str_db_type = nm_db_type($conn['dbms']);
        $arr_tables_fk = array();
        if (nm_db_sc_type($str_db_type) == 'mysql' || nm_db_sc_type($str_db_type) == 'postgres' || nm_db_sc_type($str_db_type) == 'interbase') {
            if (isset($_SESSION['nm_session']['cache'][$str_db])) {
                unset($_SESSION['nm_session']['cache'][$str_db]);
            }
            $obj_db_interface = new nmDbInterface($nm_db_usu, $str_db_type, $str_db, $this->obj_con, $this->getCharset());
            $arr_tables_fk = $obj_db_interface->getForeignKeys($str_db, $conn);
        }

        foreach ($arr_tables as $table) {
            if (isset($arr_tables_fk['normal']) && count($arr_tables_fk['normal']) > 0) {
                foreach ($arr_tables_fk['normal'] as $table_fk => $data_fk) {
                    foreach ($data_fk as $fk => $data) {
                        //echo $table_fk . "::". $data[0]['target_table'] ."::" . $prefix_table. $table, "<br/>";
                        if ($data[0]['target_table'] == $prefix_table . $table) {
                            if (nm_db_sc_type($str_db_type) == 'mysql') {
                                $str_sql = "ALTER TABLE " . $table_fk . " DROP FOREIGN KEY " . $fk;
                                $nm_db_usu->Execute($str_sql);
                            } elseif (nm_db_sc_type($str_db_type) == 'postgres') {
                                $str_sql = "ALTER TABLE " . $table_fk . " DROP CONSTRAINT " . $fk;
                                $nm_db_usu->Execute($str_sql);
                            }
                        }
                    }
                }
            }
            $if_exists = "";
            if ($str_db_type == 'mysql') {
                $nm_db_usu->Execute("SET FOREIGN_KEY_CHECKS=0;");
            } else if ($str_db_type == 'sqlite') {
                $if_exists = ' IF EXISTS ';
            }
            $str_sql = "DROP TABLE " . $if_exists . $prefix_table . ($str_db_type == 'interbase' ? strtoupper($table) : $table);
            $nm_db_usu->Execute($str_sql);
        }
        $nm_db_usu->Close();
        set_error_handler($previous_error);
    }

    /**
     * Cria as tabelas, com o prefixo selecionado
     *
     *
     * @access  protected
     * @global  array $nm_config Array com configuracao do ScriptCase.
     */
    function CreateTables($str_db, $prefix_table = 'notif_')
    {
        global $nm_config;

        $arr_tables = $this->returnLevelTables();

        $conn = $this->obj_con->GetConnection($str_db);
        $_SESSION['nm_session']['module_notification']['oracle11'] = false;
        nm_load_class('interface', 'Group');
        $obj_group = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
        $force_utf8 = ($obj_group->GetData('force_db_utf8') == 'S');

        $previous_error = set_error_handler("nm_faz_nada");

        $nm_db_usu = nm_db_connect($conn, __FILE__, __LINE__, true, "", $force_utf8);
        $db_type = nm_db_type($conn['dbms']);
        $charset = $this->getCharset();
        $extra = '';//(nm_db_sc_type($db_type) == 'mysql' && nm_crypt_decode($conn['mysql_encoding']) == 'utf8mb4') ? '_utf8mb4' : '';
        // echo $db_type . '::' . $extra;
        if(nm_db_sc_type($db_type) == 'oracle'){
            $rs = $nm_db_usu->Execute(nm_decode_utf8_charset("SELECT BANNER FROM V\$VERSION", $charset));
            $__tmp = $rs->GetArray();
            if(isset($__tmp[0][0])){
                $__tmp = strtr($__tmp[0][0], ['Oracle Database ' => '']);
                $__tmp = explode(' ', $__tmp);
                if((int)$__tmp[0] <= 11) {
                    $_SESSION['nm_session']['module_notification']['oracle11'] = true;
                    $extra = '11';
                }
            }
        }
        $str_file = $nm_config['path_lib_sql'] . "module_notification/create_" . nm_db_sc_type($db_type) . $extra . ".sql";
        if (!is_file($str_file)) {
            $str_file = $nm_config['path_lib_sql'] . "module_notification/create_default.sql";
        }
        $sql_file = file($str_file);
        $sql_create = array();
        $tabela_key = "nada";
        foreach ($sql_file as $k => $line) {
            if (stripos($line, 'Add table ') !== FALSE) {
                $tabela_key = trim(substr($line, 13, 25));
                $tabela_key = str_replace('"', '', $tabela_key);
                $sql_create[$tabela_key] = "";
            } else {
                if (isset($sql_create[$tabela_key])) {
                    $sql_create[$tabela_key] .= $line;
                } else {
                    $sql_create[$tabela_key] = $line;
                }
            }

        }

        $arr_alter = array();
        $str_file = $nm_config['path_lib_sql'] . "module_notification/alter_" . $db_type .$extra. ".sql";
        if (is_file($str_file)) {
            $sql_file = file($str_file);
            $tabela_key = "nada";
            foreach ($sql_file as $k => $line) {
                $line = trim($line);
                if (strpos($line, 'Alter table ') !== FALSE) {
                    $tabela_key = trim(strtr($line, array('Alter table ' => '', '*/' => '', '"' => '', '/*' => '')));
                    $arr_alter[$tabela_key] = [];
                } else if (!empty($line)) {
                    $arr_alter[$tabela_key][] = $line;
                }
            }
        }


        $sql_total = "";
        $ret = "";


        $arr_err = array();
        foreach ($arr_tables as $table) {
            $ret .= "<b>" . nm_get_text_lang("['creating_tables']") . " " . $prefix_table . $table . "... </b><br/>";
            $key = "notif_" . $table;

            $sql = $sql_create[$key];
            $sql_alter = isset($arr_alter[$key]) ? implode($arr_alter[$key]) : "";

            $arr_replace = array(
                //";" => "",
                ($db_type == 'interbase' ? "NOTIFTABLE_" : "notiftable_") => ($db_type == 'interbase' ? strtoupper($prefix_table) : $prefix_table)
            );

            $sql = strtr($sql, $arr_replace);
            $sql_alter = strtr($sql_alter, $arr_replace);

            $sql_total .= $sql;

            $nm_db_usu->Execute(nm_decode_utf8_charset(trim($sql), $charset));
            $erro = $nm_db_usu->ErrorMsg();
            switch ($db_type) {
                case 'mysql':
                    if (strpos($erro, 'Invalid default value for') !== FALSE ) {
                        $erro = '';
                        $nm_db_usu->Execute(nm_decode_utf8_charset(trim(strtr($sql, ['datetime NOT NULL DEFAULT CURRENT_TIMESTAMP' => 'timestamp DEFAULT CURRENT_TIMESTAMP'])), $charset));
                    }
                    break;
                case 'mssql':
                    if (strpos($erro, ': -28') !== FALSE || trim($erro) == "The active result for the query contains no fields.") {
                        $erro = '';
                    }
                    break;
                case 'oracle':
                    if (strpos($erro, 'ORA-24344:') !== FALSE || strpos($erro, 'ORA-24374:') !== FALSE) {
                        $erro = '';
                    }
                    break;
                case 'informix':
                    if (strpos($erro, '-11031]') !== FALSE) {
                        $erro = '';
                    }
                    break;
                case 'db2':
                    if (strpos($erro, 'CLI0115E') !== FALSE) {
                        $erro = '';
                    }
                    break;
            }

            if (isset($sql_alter) && is_array($sql_alter) && count($sql_alter) > 0) {
                foreach ($sql_alter as $_sql) {
                    $_sql = strtr($_sql, $arr_replace);
                    $sql_total .= $_sql . "\n\n";
                    $nm_db_usu->Execute(nm_decode_utf8_charset(trim($_sql), $charset));
                }
            }

            $ret .= "&nbsp;&nbsp;&nbsp;";
            //mantis 0023964
            if (!empty($erro) && $db_type != 'sqlite') {
                $aux = conv_utf8_all($erro, $charset);
                $ret .= $aux;
                $arr_err[] = nm_get_text_lang("['creating_tables']") . " " . $prefix_table . $table . '<p>' . $aux . '</p>';

            } else {
                $ret .= 'Ok';
            }
            //$ret .= (!empty($erro)) ? conv_utf8_all($erro, $charset) : "Ok";

            $ret .= "<br/><br/>";
        }

        set_error_handler($previous_error);

        $this->SetSessionWithTables($prefix_table, $db_type, $arr_tables, $str_db, $conn);
        $sql_name = $nm_config['path_tmp'] . "sql_module_notification_" . md5($sql_total) . ".sql";
        file_put_contents($sql_name, $sql_total);
        $sql_name = str_replace($nm_config['path_tmp'], $nm_config['url_tmp'], $sql_name);
        $ret .= "<div id='id_sql_total' style='display:none;'>" . nl2br($sql_total) . "</div>";
        $nm_db_usu->Close();

        nm_load_class('interface', 'Connection');
        $obj_con = nmConnection::singleton($_SESSION['nm_session']['user']['cod_grp']);
        $obj_con->delCache((isset($_POST['tabela_conn']))?$_POST['tabela_conn']:"");

        return array($sql_name, $ret, $arr_err);
    }

    /**
     * Carrega a sessao com os valores default de DB.
     *
     *
     * @access  protected
     * @global  array $nm_config Array com configuracao do ScriptCase.
     */
    function SetSessionWithTables($prefix, $type_db, $arr_tables, $str_db, $conn, $is_create = true)
    {
        global $nm_db_usu;
        $arr_sess = array();
        if (strpos($prefix, '.') === FALSE) {
            switch ($type_db) {
                case 'mssql':
                    $subtype_db = 'dbo.';
                    break;
                case 'oracle':
                    $subtype_db = (strpos($prefix, '.') === FALSE) ? nm_crypt_decode($conn['user']) . '.' : 'SYSTEM.';
                    break;
                case 'postgres':
                    $subtype_db = 'public.';
                    break;
                default:
                    $subtype_db = '';
                    break;
            }
            $prefix = $subtype_db . $prefix;
        }

        if (in_array('inbox', $arr_tables)) {
            $arr_sess['inbox']['table'] = $prefix . 'inbox';
            $arr_sess['inbox']['inbox_id'] = 'inbox_id';
            $arr_sess['inbox']['notif_id'] = 'notif_id';
            $arr_sess['inbox']['login'] = 'login';
            $arr_sess['inbox']['notif_dtsent'] = 'notif_dtsent';
            $arr_sess['inbox']['notif_ontop'] = 'notif_ontop';
            $arr_sess['inbox']['notif_isread'] = 'notif_isread';
            $arr_sess['inbox']['notif_dtread'] = 'notif_dtread';
            $arr_sess['inbox']['notif_tags'] = 'notif_tags';
            $arr_sess['inbox']['notif_important'] = 'notif_important';
        }
        if (in_array('pref', $arr_tables)) {
            $arr_sess['pref']['table'] = $prefix . 'pref';
            $arr_sess['pref']['login'] = 'login';
            $arr_sess['pref']['receive_email'] = 'receive_email';
            $arr_sess['pref']['receive_sms'] = 'receive_sms';
        }
        if (in_array('tags', $arr_tables)) {
            $arr_sess['tags']['table'] = $prefix . 'tags';
            $arr_sess['tags']['tag_id'] = 'tag_id';
            $arr_sess['tags']['tag_title'] = 'tag_title';
            $arr_sess['tags']['login'] = 'login';
            $arr_sess['tags']['tag_color'] = 'tag_color';
            $arr_sess['tags']['tag_active'] = 'tag_active';
        }

        if (in_array('notifications', $arr_tables)) {
            $arr_sess['notifications']['table'] = $prefix . 'notifications';
            $arr_sess['notifications']['notif_id'] = 'notif_id';
            $arr_sess['notifications']['notif_title'] = 'notif_title';
            $arr_sess['notifications']['notif_message'] = 'notif_message';
            $arr_sess['notifications']['notif_dtcreated'] = 'notif_dtcreated';
            $arr_sess['notifications']['notif_ontop'] = 'notif_ontop';
            $arr_sess['notifications']['notif_dtexpire'] = 'notif_dtexpire';
            $arr_sess['notifications']['notif_categ'] = 'notif_categ';
            $arr_sess['notifications']['notif_login_sender'] = 'notif_login_sender';
            $arr_sess['notifications']['notif_type'] = 'notif_type';
            $arr_sess['notifications']['notif_link'] = 'notif_link';
            $arr_sess['notifications']['deleted_at'] = 'deleted_at';
        }
        if (in_array('profiles', $arr_tables)) {
            $arr_sess['profiles']['table'] = $prefix . 'profiles';
            $arr_sess['profiles']['profile_id'] = 'profile_id';
            $arr_sess['profiles']['profile_name'] = 'profile_name';
            $arr_sess['profiles']['profile_users'] = 'profile_users';
            $arr_sess['profiles']['profile_groups'] = 'profile_groups';
            $arr_sess['profiles']['profile_public'] = 'profile_public';
            $arr_sess['profiles']['profile_owner'] = 'profile_owner';
        }
        if (in_array('user_tags', $arr_tables)) {
            $arr_sess['user_tags']['table'] = $prefix . 'user_tags';
            $arr_sess['user_tags']['user_tags_id'] = 'user_tags_id';
            $arr_sess['user_tags']['login'] = 'login';
            $arr_sess['user_tags']['login_sender'] = 'login_sender';
            $arr_sess['user_tags']['tags'] = 'tags';
        }
        $arr_sess['sec_users']['table'] = isset($_REQUEST['table_usr']) ? $_REQUEST['table_usr'] : $_SESSION['nm_session']['module_notification']['profile']['table_usr'];
        $arr_sess['sec_users']['login'] = isset($_REQUEST['table_usr_field_login']) ? $_REQUEST['table_usr_field_login'] : $_SESSION['nm_session']['module_notification']['profile']['table_usr_field_login'];
        $arr_sess['sec_users']['name'] = isset($_REQUEST['table_usr_field_name']) ? $_REQUEST['table_usr_field_name'] : $_SESSION['nm_session']['module_notification']['profile']['table_usr_field_name'];
        $arr_sess['sec_users']['email'] = isset($_REQUEST['table_usr_field_email']) ? $_REQUEST['table_usr_field_email'] : $_SESSION['nm_session']['module_notification']['profile']['table_usr_field_email'];
        $arr_sess['sec_users']['phone'] = isset($_REQUEST['table_usr_field_phone']) ? $_REQUEST['table_usr_field_phone'] : $_SESSION['nm_session']['module_notification']['profile']['table_usr_field_phone'];

        if ($_REQUEST['usr_grp'] == 'grp') {
            $arr_sess['sec_groups']['table'] = isset($_REQUEST['table_grp']) ? $_REQUEST['table_grp'] : $_SESSION['nm_session']['module_notification']['profile']['table_grp'];
            $arr_sess['sec_groups']['group_id'] = isset($_REQUEST['table_grp_field_group_id']) ? $_REQUEST['table_grp_field_group_id'] : $_SESSION['nm_session']['module_notification']['profile']['table_grp_field_group_id'];
            $arr_sess['sec_groups']['description'] = isset($_REQUEST['table_grp_field_description']) ? $_REQUEST['table_grp_field_description'] : $_SESSION['nm_session']['module_notification']['profile']['table_grp_field_description'];

            $arr_sess['sec_users_groups']['table'] = isset($_REQUEST['table_usr_grp']) ? $_REQUEST['table_usr_grp'] : $_SESSION['nm_session']['module_notification']['profile']['table_usr_grp'];
            $arr_sess['sec_users_groups']['login'] = isset($_REQUEST['table_usr_field_login']) ? $_REQUEST['table_usr_field_login'] : $_SESSION['nm_session']['module_notification']['profile']['table_usr_field_login'];
            $arr_sess['sec_users_groups']['group_id'] = isset($_REQUEST['table_grp_field_group_id']) ? $_REQUEST['table_grp_field_group_id'] : $_SESSION['nm_session']['module_notification']['profile']['table_grp_field_group_id'];
        }


        if (!is_array($_SESSION['nm_session']['module_notification']['profile'])) {
            $_SESSION['nm_session']['module_notification']['profile'] = array();
        }

        if ($type_db == 'oracle') {
            foreach ($arr_sess as $k => $_arr) {
                foreach ($_arr as $k2 => $str) {
                    $arr_sess[$k][$k2] = strtoupper($str);
                }
            }
        }
        //cuuuurto circuuuuuito
        if (!isset($_SESSION['nm_session']['cache'])) {
            $_SESSION['nm_session']['cache'] = array();
            $_SESSION['nm_session']['cache']['tables'] = array();
            $_SESSION['nm_session']['cache']['tables_fields'] = array();
        } else if (!isset($_SESSION['nm_session']['cache']['tables'])) {
            $_SESSION['nm_session']['cache']['tables'] = array();
        }
        if (!isset($_SESSION['nm_session']['cache']['tables_fields'])) {
            $_SESSION['nm_session']['cache']['tables_fields'] = array();
        }
        if ($is_create) {
            foreach ($arr_sess as $key => $_arr) {
                foreach ($_arr as $k => $str) {
                    $str = ($type_db == 'interbase' ? strtoupper($str) : $str);
                    $arr_sess[$key][$k] = $str;
                    if ($k == 'table') {
                        $_SESSION['nm_session']['cache']['tables'][$str_db][0][0][''][] = $str;
                        continue;
                    }
                    $bol_dont_protect = false;
                    $_SESSION['nm_session']['cache']['tables_fields'][$str_db][$arr_sess[$key]['table']][$bol_dont_protect][$bol_dont_protect][] = $str;
                }
            }
        }
        $_SESSION['nm_session']['module_notification']['profile'] = array_merge($_SESSION['nm_session']['module_notification']['profile'], $arr_sess);

    }

    /**
     * Com o botão pressionado, decide qual tela exibir.
     *
     * @param array $arr Variavel contendo POST
     *
     * @access  protected
     */
    function ChangeDisplay($arr)
    {

        global $nm_template, $nm_config;

        $this->GetSteps();

        switch ($arr['action']) {
            case 'back':
                $this->step_now = $this->before;
                break;
            case 'next':
                $this->PutInSession($_POST);
                $this->step_now = $this->after;
                break;
            case 'generate':
                $this->PutInSession($_POST);
                $nm_template->SetVar('arr_session', $this->session_js());
                $tipo_nivel = $_SESSION['nm_session']['module_notification']['profile']['tipo_nivel'];
                $nm_template->SetVar('block_image_help', $this->GetImgManual('module_notification2_generate_' . $tipo_nivel, NM_HELP_MENU_CONFIG));
                $nm_template->Display("body_step_generate", 'module_notification');
                nm_print_flush('');
                exit;
                break;
            case 'compile':
                $this->generateCompile();
                exit;
                break;

        }

        $_SESSION['nm_session']['module_notification']['profile']['tipo_nivel'] = 'grp';
        $nm_template->SetVar('arr_session', $this->session_js());
        $this->DoSteps();
        include($nm_config['path_lib'] . 'sc_manual.inc.php');

        // $id = ;
        $anchor = $this->step_now . '_' . (isset($_SESSION['nm_session']['module_notification']['profile']['tipo_nivel']) ? $_SESSION['nm_session']['module_notification']['profile']['tipo_nivel'] : "");
        $anchor .= (isset($_SESSION['nm_session']['module_notification']['profile']['tipo_nivel'])
        && $_SESSION['nm_session']['module_notification']['profile']['tipo_nivel'] == 'ldap_app' ? '_total' : '');
        $nm_template->SetVar('block_image_help', $this->GetImgManual('module_notification2_' . $anchor, NM_HELP_MENU_CONFIG));

        switch ($this->step_now) {
            case 'carregar':
                unset($_SESSION['nm_session']['module_notification']['profile']);
                $nm_template->SetVar('option_profile', $this->LoadOptionProfile(true));
                break;
            case 'tabela':
                $nm_template->SetVar('arr_connections', $this->obj_con->GetAllConnections());
                $nm_template->SetVar('tipo_nivel', $_SESSION['nm_session']['module_notification']['profile']['tipo_nivel']);
                break;
            case 'associar':

                $arr_tables = nm_db_tables($_SESSION['nm_session']['module_notification']['profile']['tabela_conn'], __FILE__, __LINE__);

                $charset = $this->getCharset();
                foreach ($arr_tables as $k => $v) {
                    $arr_tables[$k] = conv_utf8_all($v, $charset);
                }
                $nm_template->SetVar('arr_tables', array_unique($arr_tables));

                break;
            case 'config' :
                nm_load_class('interface', 'Group');
                $obj_grupo = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
                $arr_schemas = explode(':', $obj_grupo->GetData('schemas'));
                $val_def = $obj_grupo->GetValPadroes($_SESSION['nm_session']['user']['cod_grp']);
                $option = '';
                foreach ($arr_schemas as $schema) {
                    $arr_tmp_list_change = explode('__NM__', $schema);
                    list($mod, $show) = $arr_tmp_list_change;
                    $option .= "<option value='" . $schema . "'";
                    $option .= ($schema == $val_def['def_template'] ? "selected='selected'" : '') . ">" . $show . "</option>";
                }
                $nm_template->SetVar('options_schemas', $option);
                $nm_template->SetVar('count_langs_prj', count(explode(':', $obj_grupo->GetData('locales'))));

                nm_load_class('interface', 'Log');
                $log = nmLog::singleton($_SESSION['nm_session']['user']['cod_grp'], $_SESSION['nm_session']['user']['cod_ver']);
                $arr_schemas = $log->ListSchemas($_SESSION['nm_session']['user']['cod_grp'], $_SESSION['nm_session']['user']['cod_ver']);

                $option = "<option value=''></option>";
                foreach ($arr_schemas as $schema) {
                    $option .= "<option value='" . $schema['Name_Schema'] . "'>" . $schema['Name_Schema'] . "</option>";
                }
                $nm_template->SetVar('options_log', $option);

                nm_load_class('interface', 'Application');
                $obj_app = new nmApplication();
                $datas = $obj_app->GetApplications($_SESSION['nm_session']['user']['cod_grp'], $_SESSION['nm_session']['user']['cod_ver'], array('Cod_Apl', 'Tipo_Apl', 'friendly_name'));
                //$option = "<option value=''></option>";
                $option = "<option value='new_menu'>-- " . nm_get_text_lang("['menu_option']") . " --</option>";
                $selected = "selected='selected'";
                foreach ($datas as $apl) {
                    if (in_array($apl['Tipo_Apl'], array(NM_APP_TYPE_MENU, NM_APP_TYPE_MENUTREE, NM_APP_TYPE_MENU2))) {
                        $option .= "<option " . $selected . " value='" . $apl['Cod_Apl'] . "#@#" . $apl['Tipo_Apl'] . "#@#" . $apl['friendly_name'] . "'>" . $apl['Cod_Apl'] . "</option>";
                        $selected = "";
                    }
                }
                $nm_template->SetVar('options_menu', $option);
                nm_load_class('interface', 'Application');

                nm_load_class('interface', 'Group');
                $obj_grp = nmGroup::singleton($_SESSION['nm_session']['user']['cod_grp']);
                $grp_apis = $obj_grp->GetData('api');

                $arr_apis = nm_get_arr_api(true);
                $_arr = [];
                $_arr_mail = [];
                $_arr_sms = [];
                if (is_array($arr_apis) && is_array($grp_apis)) {
                    foreach ($arr_apis as $mod => $arr_api) {
                        foreach ($arr_api as $k => $api) {
                            if (!in_array($mod . "__NM__" . $k, $grp_apis) || !in_array($api['type'], ['email', 'sms', 'auth'])) continue;

                            $_arr[$mod][$k] = $api['name'] . ' - ' . $api['gateway'];
                            if ($api['type'] == 'email') {
                                $_arr_mail[$mod][$k] = $api['name'] . ' - ' . $api['gateway'];
                            }
                            if ($api['type'] == 'sms') {
                                $_arr_sms[$mod][$k] = $api['name'] . ' - ' . $api['gateway'];
                            }
                        }
                    }
                }

                $nm_template->SetVar('options_api', $_arr);
                $nm_template->SetVar('options_smtp_api', $_arr_mail);
                $nm_template->SetVar('options_sms_api', $_arr_sms);

                $arr_tables = nm_db_tables($_SESSION['nm_session']['module_notification']['profile']['tabela_conn'], __FILE__, __LINE__);
                $charset = $this->getCharset();
                $html = '';
                $tb_search = "apps";
                foreach ($arr_tables as $k => $v) {
                    $v = conv_utf8_all($v, $charset);
                    $selected = "";
                    if (stripos($v, $tb_search) !== false) {
                        $selected = "selected='selected'";
                        $tb_search = "@@@@";
                    }
                    $html .= "<option " . $selected . " value='" . $v . "'>" . $v . "</option>";
                }
                $nm_template->SetVar('apps_table', $html);

                $html = '';
                $tb_search = $_SESSION['nm_session']['module_notification']['profile']['usr_grp'] == 'grp' ? "groups_apps" : "users_apps";
                if ($tb_search == 'users_apps') {
                    $html .= "<option value='@@no-table@@'> -- " . nm_get_text_lang("['no_table_to_relationship']") . " -- </option>";
                }
                $achou = false;
                foreach ($arr_tables as $k => $v) {
                    $v = conv_utf8_all($v, $charset);
                    $selected = "";
                    if (stripos($v, $tb_search) !== false) {
                        $selected = "selected='selected'";
                        $tb_search = "@@@@";
                        $achou = true;
                    }
                    $html .= "<option " . $selected . " value='" . $v . "'>" . $v . "</option>";
                }
                if (!$achou) {
                    $html = '';
                    if ($tb_search == 'users_apps') {
                        $html .= "<option value='@@no-table@@'> -- " . nm_get_text_lang("['no_table_to_relationship']") . " -- </option>";
                    }
                    $tb_search = $_SESSION['nm_session']['module_notification']['profile']['usr_grp'] != 'grp' ? "groups_apps" : "users_apps";
                    foreach ($arr_tables as $k => $v) {
                        $v = conv_utf8_all($v, $charset);
                        $selected = "";
                        if (stripos($v, $tb_search) !== false) {
                            $selected = "selected='selected'";
                            $tb_search = "@@@@";
                        }
                        $html .= "<option " . $selected . " value='" . $v . "'>" . $v . "</option>";
                    }
                }
                $nm_template->SetVar('usr_grp_apps_table', $html);


                $output = [];
                if (function_exists("BreakCSS")) {
                    $cssData = file_get_contents($nm_config['path_devel'] . 'generator/nmGen/navMenu/common/themes.css');
                    $arr_css_themes = BreakCSS($cssData);

                    foreach ($arr_css_themes['all'] as $k => $v) {
                        if (strpos($k, 'data-aetheme=') !== false && strpos($k, '@') === false) {
                            $out = preg_replace("/\*\[data\-aetheme\=([A-Za-z0-9\_\-]*)\]/", '$1', $k);
                            $name = ucwords(str_replace('-', ' ', $out));
                            $output[$out] = [
                                'name' => $name,
                                'p' => $v['--theme-color-primary'],
                                's' => $v['--theme-color-accent'],
                                'f' => $v['--theme-color-text'],
                                'b' => $v['--theme-box-shadow'],
                            ];
                        }
                    }
                }

                $nm_template->SetVar('themes_arr', $output);

                break;

        }

        $nm_template->Display("body_base", 'module_notification');
    }//returnLevelTables

    function GetSteps()
    {
        if (!isset($_POST['step_now'])) {
            return;
        }
        if (!isset($this->step_now) || empty($this->step_now)) {
            $this->step_now = $_POST['step_now'];
            $this->before = $_POST['step_before'];
            $this->after = $_POST['step_after'];
        }
    }//DropTables

    function PutInSession($arr)
    {
        global $obj_lic, $nm_db_usu;
        switch ($arr['step_now']) {
            case 'config':
                $_arr_config = array('usu_carac_letra', 'usu_carac_num', 'usu_carac_accent', 'usu_carac_cedilla', 'usu_carac_space', 'usu_carac_dot', 'usu_carac_comma',
                    'pass_carac_letra', 'pass_carac_num', 'pass_carac_accent', 'pass_carac_cedilla', 'pass_carac_space', 'pass_carac_dot', 'pass_carac_comma');
                foreach ($_arr_config as $chave) {
                    if (!isset($arr['config_login'][$chave])) {
                        $arr['config_login'][$chave] = 'N';
                    }
                }
                if (!isset($arr['config_general']['perm_new_user'])) {
                    $arr['config_general']['perm_new_user'] = 'N';
                }
                if (!isset($arr['pop_app']['include_apps'])) {
                    $arr['pop_app']['include_apps'] = 'N';
                }
                if (!isset($arr['pop_usr']['active'])) {
                    $arr['pop_usr']['active'] = 'N';
                }
                if (!isset($arr['pop_usr']['priv_admin'])) {
                    $arr['pop_usr']['priv_admin'] = 'N';
                }
                if(isset($_REQUEST['pop_app']['table_app'])){
                    $charset = $this->getCharset();
                    $arr_conn = $this->obj_con->GetConnection($_SESSION['nm_session']['module_notification']['profile']['tabela_conn']);
                    $arr_flds_apps = nm_db_fields($_SESSION['nm_session']['module_notification']['profile']['tabela_conn'], nm_decode_utf8_charset($_REQUEST['pop_app']['table_app'], $charset), $nm_db_usu, $this->obj_con);

                    $_SESSION['nm_session']['module_notification']['profile']['sec_apps']['table'] = $_REQUEST['pop_app']['table_app'];
                    $_SESSION['nm_session']['module_notification']['profile']['sec_apps']['app_name'] = $arr_flds_apps[0] ?? 'app_name';
                    $_SESSION['nm_session']['module_notification']['profile']['sec_apps']['app_type'] = $arr_flds_apps[1] ?? 'app_type';
                    $_SESSION['nm_session']['module_notification']['profile']['sec_apps']['description'] = $arr_flds_apps[2] ?? 'description';
                }
                break;
            case 'tabela':
                if (!isset($arr['tabela_logged'])) {
                    $arr['tabela_logged'] = 'N';
                }
                if (!isset($arr['tabela_social'])) {
                    $arr['tabela_social'] = 'N';
                }
                break;
        }

        foreach ($arr as $k => $data) {
            if (!in_array($k, array('action', 'step_now', 'step_before', 'step_after', 'option_profile'))) {
                $_SESSION['nm_session']['module_notification']['profile'][$k] = $data;
            }
        }
    }//CreateTables

    /**
     * Retorna a sessao para escrever em javascript.
     *
     *
     * @access  protected
     * @global  array $nm_config Array com configuracao do ScriptCase.
     */
    function session_js()
    {
        $session_js = "	var arr_session = new Array();\n";

        if (isset($_SESSION['nm_session']['module_notification']['profile']) && is_array($_SESSION['nm_session']['module_notification']['profile'])) {
            foreach ($_SESSION['nm_session']['module_notification']['profile'] as $k => $arr_data) {
                if (!is_array($arr_data)) {
                    $session_js .= "\t arr_session['" . $k . "'] = '" . $arr_data . "';\n";
                } else {
                    foreach ($arr_data as $k2 => $data) {
                        if (!is_array($data)) {
                            $session_js .= "\t arr_session['" . $k . "[" . $k2 . "]'] = '" . $data . "';\n";
                        }
                    }
                }
            }
        }
        return $session_js;
    }

    function generateCompile()
    {
        echo "<script>var no_change = true;</script>";
        global $nm_config;
        //$str_apl_initial = $_SESSION['nm_session']['module_notification']['profile']['config_general']['prefix_app'] . "Login";
        //$str_apl_initial_type = NM_APP_TYPE_CONTROL;
        $str_apl_initial_cod_grp = $_SESSION['nm_session']['user']['cod_grp'];
        $str_apl_initial_versao = $_SESSION['nm_session']['user']['cod_ver'];
        $nm_list_app_compile = $_SESSION['nm_session']['arr_apps'];

        include_once($nm_config['path_iface'] . "generate_code.php");
    }//load_variable_replace

    function DoSteps()
    {
        global $nm_template;
        $this->GetSteps();

        $k_now = array_search($this->step_now, $this->arr_steps);

        $this->after = ($k_now + 1);
        $this->before = ($k_now - 1);

        $this->after = (array_key_exists($this->after, $this->arr_steps)) ? $this->arr_steps[$this->after] : 0;
        $this->before = (array_key_exists($this->before, $this->arr_steps)) ? $this->arr_steps[$this->before] : 0;

        $nm_template->SetVar('step_now', $this->step_now);
        $nm_template->SetVar('step_before', $this->before);
        $nm_template->SetVar('step_after', $this->after);
        $nm_template->SetVar('content', "body_step_" . $this->step_now);

    }//load_sql

    function LoadOptionProfile($arr = false)
    {
        global $nm_config;
        $arr_paths = array('scriptcase' => $nm_config['path_scriptcase'] . 'module_notification/',
            'sys' => $nm_config['path_sys'] . 'module_notification/',
            'grp' => $nm_config['path_grp'] . $_SESSION['nm_session']['user']['cod_grp'] . '/module_notification/',
            'usr' => $nm_config['path_usr'] . $_SESSION['nm_session']['user']['login'] . '/module_notification/'
        );
        $html_select_option = "";
        $arr_non_files = array('.', '..');
        $arr_return = array();
        foreach ($arr_paths as $k => $path) {

            if (!is_dir($path)) continue;
            $files = array_diff(scandir($path), $arr_non_files);
            if (count($files) == 0) continue;
            if (!isset($arr_return[$k])) {
                $arr_return[$k] = array();
            }
            $html_select_option .= "<optgroup label='" . nm_get_text_lang("['mod_" . $k . "']") . "'>";
            foreach ($files as $file) {
                $data = unserialize(file_get_contents($path . '/' . $file));
                $arr_return[$k][$file] = ['profile' => $data['perfil_save_name'], 'tipo_nivel' => $data['usr_grp']];
                $html_select_option .= "<option value='" . $k . "#@NM@#" . $file . "'>" . substr($file, 0, -3) . "</option>";
            }
            $html_select_option .= "</optgroup>";
        }
        return $arr ? $arr_return : $html_select_option;
    }//maior_id

    /**
     * Define funcoes Javascript da pagina.
     *
     * Define a lista de funcoes Javascript especificos da pagina atual.
     *
     * @access  protected
     */
    function PageJavascript()
    {
        global $nm_config, $obj_lic;

        $lang1 = nm_get_text_lang("['prefix_incorrect']");
        $lang2 = nm_get_text_lang("['folder_incorrect']");
        $lang3 = nm_get_text_lang("['profile_incorrect']");
        $url_img = $nm_config['url_scriptcase_img'];
        $str_js = "var nm_select_conn = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_select_conn']"))) . "'; \n";
        $str_js = "var nm_select_tables = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_select_tables']"))) . "'; \n";
        $str_js .= "var nm_app_exist = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_app_exist']"))) . "'; \n";
        $str_js .= "var nm_field_unselected = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_field_unselected']"))) . "'; \n";
        $str_js .= "var nm_table_exist = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_tables_exist']"))) . "'; \n";
        $str_js .= "var nm_empty_perfil = '" . (html_entity_decode(nm_get_text_lang("['js_empty_perfil']"))) . "'; \n";
        $str_js .= "var nm_confirm_no_clicked = '" . addslashes(html_entity_decode(nm_get_text_lang("['aba_no_clicked']"))) . "'; \n";
        $str_js .= "var nm_prefix_error = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_prefix_table']"))) . "'; \n";
        $str_js .= "var nm_lang_smtp_api_empty = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_smtp_api_required']"))) . "'; \n";
        $str_js .= "var nm_lang_pop_table_app_empty = '" . addslashes(html_entity_decode(nm_get_text_lang("['js_tab_app_required']"))) . "'; \n";
        $arr_manual_links = [
            'usr' => $this->GetManual('module_notification_tipo_usr', NM_HELP_MENU_CONFIG),
            'app' => $this->GetManual('module_notification_tipo_app', NM_HELP_MENU_CONFIG),
            'grp' => $this->GetManual('module_notification_tipo_grp', NM_HELP_MENU_CONFIG),
            'ldap' => $this->GetManual('module_notification_tipo_ldap', NM_HELP_MENU_CONFIG),
            'ldap_app' => $this->GetManual('module_notification_tipo_ldap_total', NM_HELP_MENU_CONFIG),
        ];
        $str_js .= "var arr_help_links =" . json_encode($arr_manual_links) . "; \n";
        $tipo_nivel = isset($_SESSION['nm_session']['module_notification']['profile']['tipo_nivel']) ? $_SESSION['nm_session']['module_notification']['profile']['tipo_nivel'] : '';

        $arr_manual_links_tabs_config = [
            'general_' . $tipo_nivel => $this->GetManual('module_notification2_config_general_' . $tipo_nivel . '_general', NM_HELP_MENU_CONFIG),
            'config_email_' . $tipo_nivel => $this->GetManual('module_notification2_config_general_' . $tipo_nivel. '_config_email', NM_HELP_MENU_CONFIG),
            'config_sms_' . $tipo_nivel => $this->GetManual('module_notification2_config_general_' . $tipo_nivel. '_config_sms', NM_HELP_MENU_CONFIG),
            'config_add_apps_' . $tipo_nivel => $this->GetManual('module_notification2_config_general_' . $tipo_nivel. '_config_add_apps', NM_HELP_MENU_CONFIG),
            'login_' . $tipo_nivel => $this->GetManual('module_notification2_config_login_' . $tipo_nivel, NM_HELP_MENU_CONFIG),
            'users_' . $tipo_nivel => $this->GetManual('module_notification2_config_users_' . $tipo_nivel, NM_HELP_MENU_CONFIG),
            'config_2fa_' . $tipo_nivel => $this->GetManual('module_notification2_config_2fa_' . $tipo_nivel, NM_HELP_MENU_CONFIG),
            'config_social_' . $tipo_nivel => $this->GetManual('module_notification2_config_social_' . $tipo_nivel, NM_HELP_MENU_CONFIG),
            'config_logged_user_' . $tipo_nivel => $this->GetManual('module_notification2_config_logged_user_' . $tipo_nivel, NM_HELP_MENU_CONFIG),
            'config_initial_data_' . $tipo_nivel => $this->GetManual('module_notification2_config_initial_data_' . $tipo_nivel, NM_HELP_MENU_CONFIG),
             'config_ldap_' . $tipo_nivel => $this->GetManual('module_notification2_config_ldap_' . $tipo_nivel, NM_HELP_MENU_CONFIG),
        ];

        $str_js .= "var arr_help_links_config_tabs = " . json_encode($arr_manual_links_tabs_config) . "; \n";

        $str_js .= <<<JS

            function nm_reload_apis(type, dest, with_custom = 0, with_empty=0)
                {

                    if(dest == null){
                        return;
                    }
                    if(type == null || type == ''){
                        document.getElementById(dest).innerHTML = '';
                        return;
                    }
                    $.ajax({
                            type: 'POST',
                            async: true,
                            url: nm_url_iface + 'module_notification.php',
                            data: 'nm_ajax=1&nm_option=reload_api&type='+type + '&with_custom=' + with_custom+ '&with_empty=' + with_empty,
                            success: function(html_retorno)
                            {
                                    var valor_default = $('#'+dest).val();
                                    document.getElementById(dest).innerHTML = html_retorno;
                                    $('#'+ dest).val( valor_default );
                            }
                        });
            }

            
            function reload_libs()
            {
                $.ajax({
						type: 'POST',
						url:  nm_url_iface+ 'module_notification.php',
						data: 'nm_ajax=1&nm_option=getLibs',
						success: function(retorno)
						{
						    $('#id_config_login_template').html(retorno);
						}
					   });
            }
            var is_working = [];
			function ajaxGetFields(table, content)
			{
                if(is_working.indexOf(table + '__' + content) !== -1){
                    return;
                }
                is_working.push(table + '__' + content);
				$.ajax({
						type: 'POST',
						url:  nm_url_iface+ 'module_notification.php',
						async: true,
						data: 'nm_ajax=1&nm_option=getfields&nm_table_usu='+table,
						success: function(retorno)
						{
							$("[data-tab="+ content +"] .select_fields option").remove();
							$("[data-tab="+ content +"] .select_fields").dropdown('clear');
                            $("[data-tab="+ content +"] .select_fields select").append(retorno).each(function()
							{
								var str_name = $(this).attr('name');
								if(arr_session)
								{
									if(arr_session[str_name] != undefined)
									{
										$(this).val(arr_session[str_name]);
									}
								}
							});
                            is_working.filter( (el) => el !== table + '__' + content);
                            
						}
				});
			}



		function call_in_associar(){
			$('#abas >li > a').click(function(){
				$('#usr').hide();
				$('#app').hide();
				$('#grp').hide();
				$('#usr_app').hide();
				$('#grp_app').hide();
				$('#usr_grp').hide();
				$('#logged').hide();
				$('#social').hide();
				$('#usr_social').hide();
				$('#settings').hide();
				$($(this).attr('href')).show();
				$('#abas > li').each(function(){
					$(this).removeClass('aba_selected');
				});

				$($(this).attr('href') + '_aba ').addClass('aba_selected');
				return false;
			});
			$('#abas >li').click(function(){
				$('#'+ $(this).attr('id') + ' > a').click();
			});
			switch('{$tipo_nivel}')
			{
		/* usr, app, grp, usr_grp, usr_app, grp_app*/
				case 'usr':
					$('#grp_aba').remove();
					$('#app_aba').remove();
					$('#usr_grp_aba').remove();
					$('#usr_app_aba').remove();
					$('#grp_app_aba').remove();
					$('#grp').remove();
					$('#app').remove();
					$('#usr_grp').remove();
					$('#usr_app').remove();
					$('#grp_app').remove();
				break;
				case 'grp':
					$('#usr_app_aba').remove();
					$('#usr_app').remove();
				break;
				case 'ldap':
				case 'app':
					$('#grp_app_aba').remove();
					$('#usr_grp_aba').remove();
					$('#grp_aba').remove();
					$('#grp').remove();
					$('#usr_grp').remove();
					$('#grp_app').remove();
				break;
			}
		}

		function disable_fields()
		{
			$('.select_fields').attr('disabled', 'disabled');
			$('.select_tables').attr('disabled', 'disabled');
		}

		function disable_button(but)
		{
			// $('#id_button_'+but).addClass('nmButtonDisabled');
			$('#id_button_'+but).attr('disabled', 'disabled');
		}

		function enable_button(but)
		{
			// $('#id_button_'+but).removeClass('nmButtonDisabled');
			$('#id_button_'+but).removeAttr('disabled').removeClass('disabled').removeClass('hidden').show();
		}

        function nm_display_menu(content)
		{
            $("input[name='pop_usr[login]']").removeAttr('required');
            $("input[name='pop_usr[login]']").removeAttr('pattern');
            $("input[name='pop_usr[login]']").removeAttr('minlength');
            $("input[name='pop_usr[login]']").removeAttr('maxlength');
            $("input[name='pop_usr[pswd]']").removeAttr('required');
            $("input[name='pop_usr[pswd]']").removeAttr('pattern');
            $("input[name='pop_usr[pswd]']").removeAttr('minlength');
            $("input[name='pop_usr[pswd]']").removeAttr('maxlength');
            $("input[name='config_general[recaptcha_secret_key]']").removeAttr('required');
            $("input[name='config_general[recaptcha_site_key]']").removeAttr('required');
            $("input[name='step_before']").val(content);
            $("input[name='step_now']").val(content);
			$('#id_button_back').attr('disabled', false);
			$("#id_button_back").click();
		}

        function nm_display_alert(str_lang,str_tipo,lang_ok,lang_cancel){
            if(typeof(str_tipo) == 'undefined'){
                $('#modal-info-message .ui.cancel.button').hide();
            }
            if(typeof(lang_ok) != 'undefined'){
                $('#modal-info-message .ui.primary.button').html(lang_ok);
            }
            if(typeof(lang_cancel) != 'undefined'){
               $('#modal-info-message .ui.cancel.button').html(lang_cancel);
            }
            $('#modal-info-span-description').html(str_lang);
            $('#modal-info-message .ui.primary.button').on('click',function(){
                $('#modal-info-message').modal('hide');
            });
            $('#modal-info-message').modal('show');
        }

        function nm_check_length_pop_data(obj,str_name){
            var min     = parseInt($(obj).attr('minlength'));
            var max     = parseInt($(obj).attr('maxlength'));
            var field   = parseInt($(obj).val().length);
            if(field < min){
                $("#"+str_name).removeClass('nm_help_hidden');
            }else if(field > max){
                $("#"+str_name).removeClass('nm_help_hidden');
            }else{
                $("#"+str_name).addClass('nm_help_hidden');
            }
        }

        function nm_check_name_perfil(){
            var response = 'ok';
            var param = {
                'p'        : $("select[name='perfil_data_mod']").val(),
                'n'        : $("input[name='perfil_save_name']").val(),
                'nm_ajax'  : 1,
                'nm_option': 'verify_profile_name'
            };
            $.ajax({
            	type: 'POST',
            	url:  nm_url_iface + 'module_notification.php',
            	data: param,
            	async: false,
            	cache: false,
            	success: function(retorno)
            	{
                    if(retorno != 'ok'){
                        $("#nm_help_error_perfil_name").html(retorno);
                        $("#nm_help_error_perfil_name").removeClass('nm_help_hidden');
                        response = 'error';
                    }else{
                        $("#nm_help_error_perfil_name").addClass('nm_help_hidden');
                        response =  'ok';
                    }
            	}
            });

            return response;
        }

        function nm_check_save_perfil(){
                var input_perfil_name = $("input[name='perfil_save_name']");
                
                    $(input_perfil_name).removeAttr('disabled');
                    if($(input_perfil_name).val() == ''){
                        $(".ui.fluid.dropdown.perfil").addClass('disabled');
                        $("#nm_help_error_perfil_name").html(nm_empty_perfil);
                        $("#nm_help_error_perfil_name").removeClass('nm_help_hidden');
                        $("#modal-save-perfil .ui.primary.approve.button").addClass('disabled');
                        $("#modal-save-perfil .ui.primary.approve.button").attr('disabled','disabled');
                    }else{
                        $(".ui.fluid.dropdown.perfil").removeClass('disabled');
                        $("#nm_help_error_perfil_name").addClass('nm_help_hidden');
                        $("#modal-save-perfil .ui.primary.approve.button").removeClass('disabled');
                        $("#modal-save-perfil .ui.primary.approve.button").removeAttr('disabled');
                    }
                
                
                $(input_perfil_name).on('input',function(){
                    if($(this).val() == '' || !correct_prefix($(this).val()) ){
                        $(".ui.fluid.dropdown.perfil").addClass('disabled');
                        $("#nm_help_error_perfil_name").html('{$lang3}');
                        $("#nm_help_error_perfil_name").removeClass('nm_help_hidden');
                        $("#modal-save-perfil .ui.primary.approve.button").addClass('disabled');
                        $("#modal-save-perfil .ui.primary.approve.button").attr('disabled','disabled');
                    }else{
                        $(".ui.fluid.dropdown.perfil").removeClass('disabled');
                        $("#nm_help_error_perfil_name").addClass('nm_help_hidden');
                        $("#modal-save-perfil .ui.primary.approve.button").removeClass('disabled');
                        $("#modal-save-perfil .ui.primary.approve.button").removeAttr('disabled');
                    }
                });
        }
        function nm_open_save_perfil(){
            $('#modal-save-perfil').modal({
                onVisible : function(){
                    nm_check_save_perfil();
                },
            	onApprove : function(){
                    
                            if($('input[name=perfil_save_name]').val() == ''){
                                $("#nm_help_error_perfil_name").html(nm_empty_perfil);
                                $("#nm_help_error_perfil_name").removeClass('nm_help_hidden');
                        		$('input[name=perfil_save_name]').focus();
                                return false;
                            }else if(!correct_prefix($('input[name=perfil_save_name]').val())){
                                $("#nm_help_error_perfil_name").html('{$lang3}');
                                $("#nm_help_error_perfil_name").removeClass('nm_help_hidden');
                        		$('input[name=perfil_save_name]').focus();
                                return false;
                            }else{
                                if(nm_check_name_perfil() == 'error'){
                                    return false;
                                }
                            }
                        var html_salva_perfil = '<input type="hidden" value="'+$("input[name='perfil_save_perfil']").val()+'" name="perfil_save_perfil" >';
                        html_salva_perfil    += '<input type="hidden" value="'+$("input[name='perfil_save_name']").val()+'" name="perfil_save_name" >';
                        html_salva_perfil    += '<input type="hidden" value="'+$("select[name='perfil_data_mod']").val()+'" name="perfil_data_mod">';
                        $("#form_notification").append(html_salva_perfil);
                    $('#id_action_form').val('generate');
                    $('#form_notification').submit();
            	}
            });
            $("#modal-save-perfil").modal('show');
        }
        function nm_show_include_apps(){
            $('#modal_show_inlude_app').modal({
                closable: true,
                blurring: true,
                onApprove: function(){
                    if($("input[name='pop_app[selected_apps][]']")){
                        $("input[name='pop_app[selected_apps][]']").remove();
                    }
                    var html_salva_perfil = '';
                    var arr_options = [];
                    var i = 0;
                    $("input[name='field_app']").each(function(){
                        if($(this).is(':checked')){
                            arr_options[i] = $(this).val();
                            html_salva_perfil = html_salva_perfil + '<input type="hidden" value="'+arr_options[i]+'" name="pop_app[selected_apps][]" >';
                            i++;
                        }
                    });
                    if(arr_options.length > 0){
                        nm_add_app_session(arr_options,html_salva_perfil);
                        nm_show_selected_apps(arr_options);
                    }else{
                        $("#table_selected_apps").hide();
                    }
                },
            }).modal('show');
        }
        function nm_add_app_session(str_param,str_html){
            var param = {
                'data'        : str_param,
                'nm_ajax'     : 1,
                'nm_option'   : 'add_app_session'
            };
            $.ajax({
                type: 'POST',
                url:  nm_url_iface + 'module_notification.php',
                data: param,
                async: false,
                cache: false,
                success: function(retorno)
                {
                    if(retorno != 'ok'){
                        nm_display_alert(retorno);
                    }else{
                        $("#form_notification").append(str_html);
                    }
                }
            });
        }

        function nm_show_selected_apps(str_param){
            var param = {
                'data'        : str_param,
                'nm_ajax'     : 1,
                'nm_option'   : 'get_selected_apps'
            };
            $.ajax({
                type: 'POST',
                url:  nm_url_iface + 'module_notification.php',
                data: param,
                async: false,
                cache: false,
                success: function(retorno)
                {
                    if(retorno != ''){
                         $("#table_selected_apps").html(retorno);
                         $("#table_selected_apps").show();
                    }else{
                         $("#table_selected_apps").hide();
                    }
                }
            });
        }

        function nm_navigate_back(str_tipo){
            if(typeof(str_tipo) == 'undefined'){
                str_tipo = 'back';
            }
            if($("select[name='tabela_conn']").length){
                $("select[name='tabela_conn']").removeAttr('required');
            }
            nm_open_load();
            $('#id_action_form').val(str_tipo);
        }

        function nm_check_login_template(str_obj){
            if(str_obj.is(':checked')){
                securityLib('enable');
                $("#id_config_login_template").removeAttr('disabled');
                $("#id_config_login_template").removeClass('disabled');
                $("#id_config_login_template_div div").eq(0).removeClass('disabled');
                $("#id_config_login_template_div a div").removeClass('disabled');
                $("#id_config_login_template_div a").eq(0).attr('href','javascript:reload_libs()');
                $("#id_config_login_template_div a").eq(1).attr('href',"javascript:parent.nm_exec_menu('libraries')");
            }else{
                securityLib('disable');
                $("#id_config_login_template").attr('disabled','disabled');
                $("#id_config_login_template_div div").eq(0).addClass('disabled');
                $("#id_config_login_template").addClass('disabled');
                $("#id_config_login_template_div a div").addClass('disabled');
                $("#id_config_login_template_div a").removeAttr('href');
            }
        }

        function securityLib(str_opt){
            $.ajax({
				type: 'POST',
				url:  nm_url_iface+ 'module_notification.php',
				data: 'nm_ajax=1&nm_option=seclib&option='+str_opt,
				success: function(retorno)
				{
                    reload_libs();
				}
		   });
        }

		$(document).ready(function()
		{
            if(arr_session){
                if(typeof(arr_session['tabela_seg']) != 'undefined'){
                    if(arr_session['tabela_seg'] == 'create'){
                        $("#menu_item_associar").removeAttr('onclick');
                        $("#menu_item_associar").attr('disabled', 'disabled');
                        $("#menu_item_associar").addClass('disabled');
                    }
                }
            }
            if($("input[name=step_now]").val() == 'tipo' ){
                $("#id_button_next").hide();
            }
            $("#2fa_option").change(function(){
                nm_reload_apis($(this).val(), '2fa_api');
            });

            $('.ui.radio.checkbox').checkbox();
            $('.dropdown').dropdown();
            $('.menu .item').tab();
		    

			var after_menu = 0;
			$(".span_menu").each(function()
			{
				if(after_menu == 1)
				{
					$(this).css('color', '#DEDEDE');
					$('#td_'+ $(this).attr('id')).attr('onclick', '');
					$('#td_'+ $(this).attr('id')).css('cursor', 'auto');
				}
				if($('input[name=step_now]').val() == $(this).attr('id') )
				{
					after_menu = 1;
				}
			});

			$("#img_"+$('input[name=step_now]').val()).show();

			function nm_display(content)
			{
				$("input[name=step_after]").val(content);
                $("input[name=step_before]").val($("#menu_item_"+content).prev('a').attr('id').replace(/menu_item_/g, ""));
				$('#id_button_next').attr('disabled', false);
				$("#id_button_next").click();
			}


			/*
			if(typeof(no_change) == 'undefined' && $('input[name=step_now]').val() != 'associar')
			{
				change_of_session();
			}
			*/
			switch($('input[name=step_now]').val())
			{
				case 'associar':
					call_in_associar();
					change_of_session();
					if(!one_empty && $('#tabela_seg').val() == 'create')
					{
						disable_fields();
					}
					else
					{
						$('.select_fields').attr('disabled', false);
						$('.select_tables').attr('disabled', false);
					}

					$('#id_button_next').click(function(){
					var retorno = true;
					var campo = '';
						$('select').each(function(k,v){
							if($(v).val() == '')
							{
								retorno = false;
								campo = $(v);
								return false;
							}
						});
						if(retorno == false)
						{
							nm_display_alert(nm_field_unselected);
							return false;
						}
						nm_open_load();
					});
					setTimeout(function(){

						if($("select[name='usr[active]']").val() == '')
						{
							$('.select_fields').attr('disabled', false);
							$('.select_tables').attr('disabled', false);
						}
					}, 1000);
				break;

				case 'carregar':
					disable_button('back');
					$('#id_button_next').click(function(){
						nm_open_load();
					});
				break;

				case 'tipo':
					$('#id_button_next').click(function(){
						nm_open_load();
					});
					$('input[name=tipo_nivel]').click(function()
					{
						nm_change_description(this.value);
                       
                        var tmp_link_manual = '';
                       $("#id_table_ldap_childs").hide();
                       eval("tmp_link_manual = arr_help_links."+ $(this).val());
                        $('.help-image-link').attr('onclick', "javascript:nm_window_manual('"+tmp_link_manual+"');return false; ")
                        
					});
                    
				break;
				case 'config':
                    $('.ui.top.attached.tabular.menu .item').click(function(){
                       $(this).addClass('aba_clicked'); 
                    });
                    $(".ui.top.attached.tabular.menu a").click(function(){
                        var data_tab_val = $(this).attr('data-tab');
                        if(data_tab_val == '2fa'){
                            data_tab_val = 'config_'+data_tab_val+'_{$tipo_nivel}';
                        }else{
                            data_tab_val = data_tab_val+'_{$tipo_nivel}';
                        }
                        var tmp_link_help = '';
                        eval("tmp_link_help = arr_help_links_config_tabs."+data_tab_val);
                        $('.help-image-link').attr('onclick', "javascript:nm_window_manual('"+tmp_link_help+"');return false; ");
                    });
                    nm_check_login_template($("input[name='config_login[use_login_template]']"));
                    if($("#id_pop_usr_include_apps").is(':checked')){
                        $("#table_selected_apps").hide();
                        $("#id_pop_usr_select_include_apps").prop('checked',false);
                        $("#id_btn_select_include_apps").addClass('disabled');
                    }else if($("#id_pop_usr_select_include_apps").is(':checked')){
                        $("#id_pop_usr_include_apps").prop('checked',false);
                        $("#id_btn_select_include_apps").removeClass('disabled');
                        $("#table_selected_apps").show();
                    }
                    $("#id_pop_usr_include_apps").click(function(){
                        $("#id_pop_usr_select_include_apps").prop('checked',false);
                        $("#id_btn_select_include_apps").addClass('disabled');
                        $("#table_selected_apps").hide();
                    });
                    $("#id_pop_usr_select_include_apps").click(function(){
                        if($(this).is(':checked')){
                            $("#id_btn_select_include_apps").removeClass('disabled');
                            $("#table_selected_apps").show();
                        }else{
                            $("#id_btn_select_include_apps").addClass('disabled');
                            $("#table_selected_apps").hide();
                        }
                        $("#id_pop_usr_include_apps").prop('checked',false);
                    });

                    $("#id_button_next").hide();
                    $("#id_button_back").hide();
					$('.img_help').click(function(e){
						nm_show_help(this,e);
						setTimeout(nm_close_help, 1500);
					});
					$('.img_help').mouseover(function(e){
						nm_show_help(this, e);
					});
					$('.img_help').mouseout(function(){nm_close_help();});

                    if('{$tipo_nivel}' != 'ldap' && '{$tipo_nivel}' != 'ldap_app')
                    {
                        $('#config_ldap').remove();
                        $('#config_ldap_aba').remove();
                    }
                    
					$('#id_folder_notification').change(function(){
						if(!correct_prefix($(this).val()))
						{
							nm_display_alert('{$lang2}');
							$(this).focus();
							return false;
						}
					});
                    $('input[name="config_general[smtp_api_custom]"]').on('click', function(){
                        if($(this).is(':checked')){
                            $('.table_custom_smtp').removeClass('disabled');
                            $('#id_combobox_smtp_api').addClass('disabled');
                        }else{
                            $('.table_custom_smtp').addClass('disabled');
                            $('#id_combobox_smtp_api').removeClass('disabled');
                        }
                    });
                    $('#smtp_api').on('change', (function(){
                        $('.table_custom_smtp').addClass('disabled');

						if($(this).val() == 'custom'){
                            $('.table_custom_smtp').removeClass('disabled');
                        }
                        i_control = true;
					}));
					$('#id_prefix_app').change(function(){
						if(!correct_prefix($(this).val()))
						{
                            $("a[data-tab=general]").click(); 
							nm_display_alert('{$lang1}');
                            $('#id_prefix_app').focus();
							return false;
						}
					});

                   
					$('#id_button_gen').click(function(){
						if(!correct_prefix($('#id_prefix_app').val()))
						{
                            $("a[data-tab=general]").click(); 
							nm_display_alert('{$lang1}');
                            $('#id_prefix_app').focus();
							return false;
						}
						if(!correct_prefix($('#id_folder_notification').val()))
						{
                            $("a[data-tab=general]").click(); 
                            nm_display_alert('{$lang2}');
							$('#id_folder_notification').focus();
							return false;
						}
						
						verify_apps($('#id_prefix_app').val());
						if($('#id_hid_has_app').val() == 'tem')
						{
                            $("a[data-tab=general]").click();
                            nm_display_alert(nm_app_exist);
						 	$('#id_prefix_app').focus();
						 	return false;
						 }

                        /*if($("a[data-tab=config_email]").length != 0 && ($('#smtp_api').val() == '' || $('#smtp_api').val() == null)){
                            nm_display_alert(nm_lang_smtp_api_empty);
                            $('#config_email_aba').trigger('click');
                            $('#smtp_api').focus();
                            return false;
                        }*/
                        if($('#id_pop_usr_include_apps').is(':checked') && $('#pop_app_table_app').val() == ''){
                             nm_display_alert(nm_lang_pop_table_app_empty);
                             return false;
                        }
                        if($("a[data-tab=config_email]").length != 0 && $('#smtp_api').val() == 'custom'){
                            var valid = true ;
                            $('.config_email_custom').each(function(i,t){
                                if(valid && $(t).attr('name') != 'config_email[smtp_security]'){
                                    valid = $(t).val() != '';
                                    if(valid == false){
                                        $('#config_email_aba').trigger('click');
                                        $(t).focus();
                                    }
                                }
                            });
                            if(!valid){
                                $("a[data-tab=config_email]").click();
                                nm_display_alert(nm_lang_smtp_api_empty);
                                return false;
                            }
                        }
                        
						var no_clicked = false;
						var aba_no_clicked;
						$(".ui.top.attached.tabular.menu a").each(function(k,v)
						{
							if(!no_clicked && !$(v).hasClass('aba_clicked'))
							{
								no_clicked = true;
								aba_no_clicked = $(v);
							}
						});
                        var tipo_nivel = '{$tipo_nivel}';
                        
						if(no_clicked)
						{
                            $("#modal-all-tabs-click-span-description").text(nm_confirm_no_clicked);
                            $('#modal-all-tabs-click').modal({
                                onCancel : function(){
                                    aba_no_clicked.click();
                                    return false;
                                },
                                onApprove: function (){
                                    nm_open_save_perfil();
                                }
                            });
							$('#modal-all-tabs-click').modal('show');
						}else{
                            nm_open_save_perfil();
                        }
					});

                    var tipo_nivel = '{$tipo_nivel}';
					switch(tipo_nivel)
					{
						case 'usr':
							$('#id_tr_grp').remove();
							$('#id_tr_app').remove();
						break;
						case 'app':
							$('#id_tr_grp').remove();
						break;
					}
                    $("form").submit(function(e){
					    if( $('#id_action_form').val() == 'next' && ( tipo_nivel == 'ldap' || tipo_nivel == 'ldap_app' ) && false == nm_ldap_test())
					    {
					         e.preventDefault();
					         return false;
					    }
                        if($('#modal-save-perfil').is(':hidden')){
                            nm_open_load();
                        }
					});
                    
                    $('input[name=perfil_save_name]').on('input',function()
					{
						if(!correct_prefix($(this).val()))
						{
                            $("#nm_help_error_perfil_name").html('{$lang3}');
							$("#nm_help_error_perfil_name").removeClass('nm_help_hidden');
							$(this).focus();
							return false;
						}else{
                            $("#nm_help_error_perfil_name").addClass('nm_help_hidden');
                        }
					});
                   
						show_save_perfil();
					

                    enable_button('gen');
					disable_button('next');
				break;
				case 'tabela':
                    disable_button('next');
                    if($("select[name='tabela_conn']").val() == ''){
                        $("#tabela_conn_refresh").removeAttr('href');
                        $("#tabela_conn_refresh").attr('disabled','disabled');
                        $("#tabela_conn_refresh div").addClass('disabled');
                    }else{
                        $("#tabela_conn_refresh").attr('href','javascript: refreshTables();');
                        $("#tabela_conn_refresh").removeAttr('disabled');
                        $("#tabela_conn_refresh div").removeClass('disabled');
                    }
					$('#id_button_next').on('click', function(){

                        if(!correct_prefix( $("input[name='tabela_seg_prefix']").val() )){
                            nm_display_alert(nm_prefix_error);
                            return false;
                        }
                        
                        var bol_verify = false;
                        $(".db_table > select").each(function(i, t){
                            if($(t).parent().parent().parent().parent().hasClass('disabled')) return;
                            if($(t).val() == '' || $(t).val() == null){
                                bol_verify = true;
                                return false;
                            }
                        });
                        if(bol_verify){
                            nm_display_alert(nm_select_tables);
                            return false;
                        }
                         if(
                            $('input[name=usr_grp]:checked').val() == 'usr' 
                            && ( $('select[name=table_usr]').val() == null || $('select[name=table_usr]').val() == '')  
                        ){
                            nm_display_alert(nm_select_tables);
                            return false;
                        }

                        if(
                            $('input[name=usr_grp]:checked').val() == 'grp' &&
                            ( $('select[name=table_usr]').val() == '' || $('select[name=table_usr]').val() == null || 
                             $('select[name=table_grp]').val() == '' || $('select[name=table_grp]').val() == null ||
                             $('select[name=table_usr_grp]').val() == '' || $('select[name=table_usr_grp]').val() == null) )
                        {
                            nm_display_alert(nm_select_tables);
                            return false;
                        }

						if($('#id_select_conn option:selected').val() == '')
						{
							nm_display_alert(nm_select_conn);
							return false;
						}

						bol_verify = verify_tables($('#id_select_conn option:selected').val(), $('#id_tabela_seg_prefix').val());
						if( 
							 $('#id_tabela_seg_create').is(':checked')
							&& !$('input[name=tabela_drop_tables]').is(':checked')
							&& bol_verify
							&& !confirm(nm_table_exist)
						  )
						{
							$('input[name=tabela_drop_tables]').focus();
							return false;
						}
						nm_open_load();
					});
                    
				break;
				
				default:
				break;
			}
            change_of_session();
            
            const togglePassword1 = document.querySelector('#togglePassword');
            const password1 = document.querySelector('#id_config_email_smtp_pass');
            try{
                togglePassword1.addEventListener('click', function (e) {
                    const type = password1.getAttribute('type') === 'password' ? 'text' : 'password';
                    password1.setAttribute('type', type);
                    this.classList.toggle('fa-eye-slash');
                });
            }catch(e){}
		});

      
		
			var one_empty = false;
			function change_of_session(){
			$("input").each(function()
			{
				switch($(this).attr('type'))
				{
					case 'radio':
						var str_name = $(this).attr('name');
						if(arr_session)
						{
							if(arr_session[str_name] != undefined)
							{
								if($(this).val() == arr_session[str_name])
								{
									$(this).attr('checked', true);
									$(this).click()
									$(this).trigger('click');
                                    $(this).trigger('change');
                                    if(str_name == 'tipo_nivel' && ( $(this).val() == 'ldap' || $(this).val() == 'ldap_app' ) )
                                    {
                                        $("#id_table_ldap_childs"). show();
                                    }
                                    else if(str_name == 'tipo_nivel')
                                    {
                                        $("#id_table_ldap_childs"). hide();
                                    }
								}
							}
						}
					break;
					case 'checkbox':
						var str_name = $(this).attr('name');
						if(arr_session)
						{
							if(arr_session[str_name] != undefined )
							{

								if( arr_session[str_name] == $(this).val())
								{
								    if($(this).val() != 'facebook' && $(this).val() != 'google' && $(this).val() != 'twitter')
								    {
									    $(this).click();
									}
									$(this).click();
									$(this).prop('checked','checked');

								}
								else
								{
									$(this).removeAttr('checked');
								}
							}
						}
					break;
					default:
						var str_name = $(this).attr('name');
						if(arr_session)
						{
							if(arr_session[str_name] != undefined)
							{
								$(this).val(arr_session[str_name]);
								$(this).change();
								$(this).trigger('change');;
							}
						}
					break;
				}
				if(!one_empty && $(this).val() == '')
				{
						one_empty = true;
				}
			});

		 $("select").each(function()
			{
				var str_name = $(this).attr('name');
				if(arr_session)
				{
					if(arr_session[str_name] != undefined)
					{
						$(this).val(arr_session[str_name]);
						if( $(this).val() == '' || $("select[name='"+ str_name +"']").val() == '')
						{
							one_empty = true;
						}
					}
				}
					$(this).trigger('change');;
			});
		}


		function nm_change_description(tipo)
		{
			$("#id_td_description > div").hide();
			$("#id_div_"+tipo).show();
		}

		function nm_show_hide_tr(id)
		{
			if($('#'+id).is(':hidden'))
			{
				$('#'+id).show();
				$('#img_'+id).attr('src', "{$url_img}img_contract.png");
			}
			else
			{
				$('#'+id).hide();
				$('#img_'+id).attr('src',"{$url_img}img_expand.png");
			}
		}

		function show_profiles(valor)
		{
			if(valor == 'use')
			{
				$("select[name=option_profile]").show();
				return;
			}
			$("select[name=option_profile]").hide();
		}


		function nm_config_help()
		{
			$('.img_help').click(function(e){
				nm_show_help(this,e);
				setTimeout(nm_close_help, 1500);
			});
			$('.img_help').mouseover(function(e){
				nm_show_help(this, e);
			});
			$('.img_help').mouseout(function(){nm_close_help();});
		}


			function nm_show_help(t,e)
			{
				var id = $(t).attr('id');
				id = id.replace('img', 'desc');

				xcurs = e.pageX + 30;
				ycurs = e.pageY - 10;
				$('#id_description_help').css('top', ycurs+'px');
				$('#id_description_help').css('left', xcurs+'px');
				$('#id_description_help > span').html( $('#'+id).html());
				$('#id_description_help').show();
			}


		function nm_close_help()
		{
			$('#id_description_help').hide();
		}


		function see_sql_local(id)
		{
			if($('#'+id).is(':visible'))
			{
				$('#'+id).hide();
				return;
			}
			$('#'+id).show(1000);
		}


			function show_sql()
			{
				if($('#id_sql_total').is(':visible'))
				{
					$('#id_sql_total').hide();
				}
				else
				{
					$('#id_sql_total').show();
				}
			}


			function nm_select_crypt(valor)
			{
				if(valor != '')
				{
					$('#id_ret_pass_send_mail').attr('disabled', 'disabled');
					$('#id_ret_pass_send_mail_desc').css('color', '#CECECE');
					$('#id_criptografia_chave').removeAttr('disabled');
					if( $('#id_ret_pass_send_mail').is(':checked'))
					{
						$('#id_ret_pass_send_mail_reset').attr('checked', true);
					}
					return;
				}

				$('#id_criptografia_chave').attr('disabled', 'disabled');
				$('#id_ret_pass_send_mail_desc').css('color', '#000');
				$('#id_ret_pass_send_mail').attr('disabled', false);

			}




	function showMsg(msg)
	{
		$('#id_msg_div_content').html(msg);
		$('#id_msg_div').show();
	}

	function compile_applications(cod_grp, versao, ver_dve)
	{
		parent.$('.nmProjectInfo').hide();
		parent.nm_app_data(cod_grp, '', '', '', '', '', '', '', '', versao, ver_dve);
		parent.nm_close_all_abas_app();

		parent.form_wiz.field_group.value = cod_grp;
		parent.form_wiz.field_ver.value = versao;
		parent.form_wiz.field_dve.value = ver_dve;

		parent.form_wiz.execute_apl_initial_cod_grp.value = cod_grp;
		parent.form_wiz.execute_apl_initial_versao.value = versao;
		parent.form_wiz.submit();
		parent.show_prj_bar();
	}

		function verify_tables(conn, prefix)
		{
			var ret = false;
			$.ajax({
				type: 'POST',
				url:  '{$nm_config['url_iface']}module_notification.php',
				async: false,
				data: 'nm_ajax=1&nm_option=verify_tables&conn='+conn + '&prefix='+prefix,
				success: function(retorno)
				{
					if(retorno == 'tem')
						ret = true;
					else
						ret = false;
				}
			});
			return ret;
		}

			function verify_apps(prefix)
			{
				$.ajax({
					type: 'POST',
					async: false,
					url:  '{$nm_config['url_iface']}module_notification.php',
					data: 'nm_ajax=1&nm_option=verify_apps&prefix='+prefix,
					success: function(retorno)
					{
						$('#id_hid_has_app').val(retorno);
					}
				});

			}

			function nm_open_load()
			{
				//$('#id_loading').toggleClass('loading-visible');
				$.blockUI({
					message: $('#id_loading').html(),
					css: {
						top: '90px',
						position:'fixed'
						}
				});
			}

			function show_save_perfil()
			{
				
					$(".perfil").removeAttr('disabled');
				
			}

			function generate_step(step)
			{
				$.ajax({
					type: 'POST',
					url:  '{$nm_config['url_iface']}module_notification.php',
					cache: false,
					data: 'nm_ajax=1&nm_option=generate&step='+step,
					success: function(retorno)
					{
						if(retorno == '')
						{
							$("#id_msgs_step"+step).show();
							$("#id_msgs_step"+(step+1)).show();
							$("#id_msgs_step"+step+"_img").attr("src", "{$nm_config['url_img']}ok.png");
							step = (step + 1);
							if(step == 4)
							{
								steps = true;
							}
							else
								generate_step((step));
						}
						else
							$('body').html(retorno);
					}
				});

			}

			function nm_verify_steps()
			{
				if(step4 && steps)
				{
					$("#id_msgs_step4_img").attr("src", "{$nm_config['url_img']}ok.png");
					$("#id_btns_ok").show();
				}
				else
					setTimeout(nm_verify_steps, 500);
			}

		function nm_check_connection(valor)
		{

            $('#tabela_conn').addClass('loading');
            if(valor == ''){ return;}
            disable_button('next');
             $('.db_table').removeClass('disabled');
             $('.db_table').addClass('loading');
            $("#tabela_conn_refresh").removeAttr('href');
            $("#tabela_conn_refresh").attr('disabled','disabled');
            $("#tabela_conn_refresh div").addClass('disabled');
            $('#img_loading_conn').show();
			$.ajax({
					type: 'POST',
					url:  '{$nm_config['url_iface']}admin_sys_allconections_test.php',
					cache: false,
					data: 'nm_ajax=1&nm_option=checkConnection&str_conn='+valor,
					success: function(retorno)
					{
                        $('#img_loading_conn').hide();
						if(retorno != '')
						{
							$('#tab_conn_erro').show();
							$('#id_select_conn').val('');
                            disable_button('next');
                            $("#tabela_conn_refresh").removeAttr('href');
                            $("#tabela_conn_refresh").attr('disabled','disabled');
                            $("#tabela_conn_refresh div").addClass('disabled');
							//$('#id_select_conn').change();
						}
						else{
							$('#tab_conn_erro').hide();
                            enable_button('next');
                            $("#tabela_conn_refresh").attr('href','javascript: refreshTables();');
                            $("#tabela_conn_refresh").removeAttr('disabled');
                            $("#tabela_conn_refresh div").removeClass('disabled');
                            getTables(valor);
                            getTablesGrp(valor);
                            getTablesUsrGrp(valor);
                        }
					}
				});
		}

        function nm_toggle_ug(valor){
                if(valor == 'usr'){
                    $('.table_grp').addClass('disabled');
                }else{
                    $('.table_grp').removeClass('disabled');
                }
        }
		function correct_prefix(prefix)
		{
            if(typeof(prefix) !== 'undefined'){
    			if('' != prefix.replace(/[a-z0-9_]+/i, "") || /^[0-9]/i.test(prefix))
    			{
    				return false;
    			}
            }
    		return true;
		}


		function nm_can_disable(valor)
		{
		    if(valor == '')
		    {
		        $('.can_disabled').hide();
		    }
		}

        function socialConfig(t)
        {
            if($(t).is(':checked'))
            {
                $("input[name^='config_general[" + $(t).val() + "'").removeAttr('disabled');
            }
            else
            {
                $("input[name^='config_general[" + $(t).val() + "'").attr('disabled', 'disabled');
            }
        }
JS;
        $this->AddJavascript($str_js);


        $str_js = " var arr_order_apl  = 'ASC';\n";
        $str_js .= " var arr_order_fol  = 'DESC';\n";
        $str_js .= " var arr_order_dt   = 'DESC';\n";
        $str_js .= " var arr_order_desc = 'DESC';\n";
        $str_js .= "function setOrderBy(str_campo)\n";
        $str_js .= "{\n";
        $str_js .= "    str_ordenacao = '';\n";
        $str_js .= "    if(str_campo=='Cod_Apl')\n";
        $str_js .= "    {\n";
        $str_js .= "      if(arr_order_apl == 'ASC')\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_apl = 'DESC';\n";
        $str_js .= "      }else\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_apl = 'ASC';\n";
        $str_js .= "      }\n";
        $str_js .= "      str_ordenacao = arr_order_apl;\n";
        $str_js .= "    }\n";
        $str_js .= "    if(str_campo=='Folder')\n";
        $str_js .= "    {\n";
        $str_js .= "      if(arr_order_fol == 'ASC')\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_fol = 'DESC';\n";
        $str_js .= "      }else\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_fol = 'ASC';\n";
        $str_js .= "      }\n";
        $str_js .= "      str_ordenacao = arr_order_fol;\n";
        $str_js .= "    }\n";
        $str_js .= "    if(str_campo=='Data_Inc')\n";
        $str_js .= "    {\n";
        $str_js .= "      if(arr_order_dt == 'ASC')\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_dt = 'DESC';\n";
        $str_js .= "      }else\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_dt = 'ASC';\n";
        $str_js .= "      }\n";
        $str_js .= "      str_ordenacao = arr_order_dt;\n";
        $str_js .= "    }\n";
        $str_js .= "    if(str_campo=='Descricao')\n";
        $str_js .= "    {\n";
        $str_js .= "      if(arr_order_desc == 'ASC')\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_desc = 'DESC';\n";
        $str_js .= "      }else\n";
        $str_js .= "      {\n";
        $str_js .= "        arr_order_desc = 'ASC';\n";
        $str_js .= "      }\n";
        $str_js .= "      str_ordenacao = arr_order_desc;\n";
        $str_js .= "    }\n";
        $str_js .= "    ajax_get_arr_apl(str_campo, str_ordenacao);\n";
        $str_js .= "}\n";
        $this->AddJavascript($str_js);
        $str_js = <<<JS
        function ajax_get_arr_apl(str_campo, str_ordenacao)
        {
            var param = {
                    'nm_ajax': 1,
                    'nm_option': 'setorderby',
                    'campo': str_campo,
                    'str_param': str_ordenacao,
                    'option': 'checkbox'
            };
            $.ajax({
                type: 'POST',
                url:  nm_url_iface + 'module_notification.php',
                data: param,
                async: false,
                cache: false,
                success: function(retorno){
                    if(retorno != ''){
                        ajax_set_arr_apl(retorno);
                    }
                }
            });            
        }
        function ajax_set_arr_apl(str_retorno)
        {
          if(str_retorno!='')
          {
            document.getElementById('id_arr_apls').innerHTML = str_retorno;
          }
        }
JS;
        $str_js = "function nm_check_all(b_checked)\n";
        $str_js .= "{\n";
        $str_js .= "  $('#id_arr_apls tbody tr:visible').find('input').prop('checked', b_checked); \n";
        $str_js .= "}\n";
        $this->AddJavascript($str_js);

        $str_js = <<<JS
        function nm_show_password(obj){
            input = obj.parent().find('input');
            if(input.prop('type') == 'text'){
                input.prop('type', 'password');
                obj.removeClass('slash');
            }else if(input.prop('type') == 'password'){
                input.prop('type', 'text');
                obj.addClass('slash');
            }
        }
JS;
        $this->AddJavascript($str_js);

        $str_js = "   var str_conn_cache = '';\n";
        $str_js .= "   function refreshTables()\n";
        $str_js .= "   {\n";
        $str_js .= "     str_conn = ''; \n";
        $str_js .= "     if(str_conn_cache != '') \n";
        $str_js .= "     { \n";
        $str_js .= "         str_conn = str_conn_cache;\n";
        $str_js .= "     } \n";
        $str_js .= "     else if($(\"select[name='tabela_conn']\").val() != '') \n";
        $str_js .= "     { \n";
        $str_js .= "         str_conn = $(\"select[name='tabela_conn']\").val();\n";
        $str_js .= "     } \n";
        $str_js .= "     $.ajax({ \n";
        $str_js .= "         url:  '" . $nm_config['url_iface'] . "wizard.php', \n";
        $str_js .= "         type: 'POST', \n";
        $str_js .= "         data: 'ajax=nm&ajax_reset_cache=true&force=1&conn=' + str_conn, \n";
        $str_js .= "         beforeSend: function() \n";
        $str_js .= "         { \n";
        $str_js .= "            nm_open_load(); \n";
        $str_js .= "         }, \n";
        $str_js .= "         success:function(msg) \n";
        $str_js .= "         { \n";
        $str_js .= "             $.unblockUI(); \n";
        $str_js .= "             str_conn_cache = '';\n";
        $str_js .= "             nm_check_connection($(\"select[name='tabela_conn']\").val());;\n";
        $str_js .= "         } \n";
        $str_js .= "     });\n";
        $str_js .= "   }\n";
        $this->AddJavascript($str_js);

        $str_js = <<<JS
        function nm_set_timeout(str_obj,str_field,str_type){
            setTimeout(() => {
                $("a[data-tab='"+str_obj+"']").attr('onclick','');
                $("a[data-tab='"+str_obj+"']").click();
                $(str_type+"[name='"+str_field+"']").focus();
                $("a[data-tab='"+str_obj+"']").attr('onclick','nm_verify_deps($(this).attr("data-tab"));');
            },'0050');
        }
        function nm_verify_deps(str_opt){
            if(str_opt != 'general'){
                verify_apps($('#id_prefix_app').val());
            }
            if($('#smtp_api').val() == 'custom' && $("a[data-tab=config_email]").hasClass('active') == true){
                var valid = 'yes';
                var field = '';
                $('.config_email_custom').each(function(i,t){
                	if(valid == 'yes' && $(t).attr('name') != 'config_email[smtp_security]'){
                		if($(t).val() == ''){
                            valid = 'no';
                            field = $(t).attr('name');
                        }
                	}
                });
            }

            if(valid == 'no' && $('#smtp_api').val() == 'custom' && $("a[data-tab=config_email]").hasClass('active') == true){
                nm_display_alert(nm_lang_smtp_api_empty);
                nm_set_timeout('config_email',field,'input');
            }
        }
JS;
        $this->AddJavascript($str_js);
    }

    /**
     * Define arquivos JS da pagina.
     *
     * Define a lista de arquivos JS especificos da pagina atual.
     *
     * @access  protected
     */
    function PageJs()
    {
        $this->AddJs('third', 'jquery_plugin/malsup-blockui/jquery.blockUI.js');
        $this->AddJs('devel', 'window.js');
//        $this->AddJs('third', 'bootstrap/js/bootstrap.min.js');
        $this->AddJs('third', 'semantic-ui/semantic.min.js');
        $this->AddJs('devel', 'menuEditor2.js');

    }


    /**
     * Define folhas de estilo da pagina.
     *
     * Define a lista de folhas de estilo especificas da pagina atual.
     *
     * @access  protected
     */
    function PageStyleCss()
    {
//        $this->AddStyleCssAfterScCss('third', 'bootstrap/css/bootstrap.min.css');
        $this->AddStyleCssAfterScCss('third', 'semantic-ui/semantic.min.css');
        $this->AddStyleCss('third', 'font-awesome/6/css/all.min.css');
    } // PageStyleCss


    /**
     * Define folhas de estilo da pagina.
     *
     * Define a lista de folhas de estilo especificas da pagina atual.
     *
     * @access  protected
     */
    function PageStyle()
    {
        global $nm_config, $nm_browser;

        $this->AddStyle("#abas li { text-decoration:none; list-style: none; cursor:pointer; padding:4px; color:#FFF;}"); //border:1px #BFDAF2 solid; padding: 3px 0px 0;
        $this->AddStyle("#id_table_ldap_childs { display:none;}"); //border:1px #BFDAF2 solid; padding: 3px 0px 0;
        $this->AddStyle(" a { text-decoration:none; font-weight: normal; text-transform: none; color:#336994; font-size:14px;}");//white-space:nowrap; padding: 0 10px;
        $this->AddStyle(".aba_selected , .aba_selected li { color:#000; font-weight:bold; background-color:#CECECE; padding:4px;}");
        $this->AddStyle(".aba_selected a { color:#000;}");
        $this->AddStyle(".aba_no_selected{ color:#000; background-color:#fffbac; }");
//        $this->AddStyle(".description, #id_description_help{	display:none;	position: absolute;	margin: 0px;	padding: 0px;	line-height: normal;	width: 160px;	color: rgb(59, 82, 118);	font-family: Verdana, Geneva, sans-serif;	font-size: 8pt;	text-align: left;	border:1px solid #BFDAF2;	background-color:#FAFACA;	white-space:normal;}");
        $this->AddStyle("#title_help{	background-color:#BFDAF2;}");
        $this->AddStyle(".img_help{	padding:0 8px;	cursor:pointer;}");
        $this->AddStyle("div.loading-invisible{display:none;}");
        $this->AddStyle("div.loading-visible{display:block; position:absolute; top:200px; left:0; width:100%; text-align:center; background:#fff; filter: alpha(opacity=80); -khtml-opacity: 0.80; -moz-opacity: 0.80; opacity: 0.80; border-top:1px solid #ddd; border-bottom:1px solid #ddd; }");
        $this->AddStyle("#id_tr_ldap_test{display:none;}");
        $this->AddStyle(".nmButton{cursor:pointer;}");
        $this->AddStyle(".can_disabled{display:none}");
        $this->AddStyle(".nm-radio-button{vertical-align: text-bottom;}");
        $this->AddStyle(".table_custom_smtp{display:none;}");
        $this->AddStyle(".nm_help_red{ color: red!important; } .nm_help_green{ color: green!important; }");
        $this->AddStyle(".nm_help_visible{ display: block!important; } .nm_help_hidden{ display: none!important; } .nm_padding_top{ padding-top: 10px; }");
    }


    function _debug_file($value)
    {
        $str_content = "\n\n=================================================\n";
        if (is_array($value)) {
            $str_content .= var_export($value, true);
        } else {
            $str_content .= $value;
        }
        file_put_contents("/var/www/debug_security.txt", $str_content, FILE_APPEND);
    }

}

?>